# Filename: merge.awk
#
# Usage: awk -f merge.awk master=master_hw_cfg dev_cfg 
#
# Input files:
#
# Master H/W config file- ascii excluding I/O devices (ref config file struct)
# Device config file 	- ascii file (sorted) containing
#				  i/o device config. 
#				
# Sample Entries:
#
#	CABINET 00 BP A S 00 RAID5 
#	CABINET 00 BP A S 02 MIO I04
#	CABINET 00 BP A S 07 ENET 
#	CABINET 00 BP D S 03 DISK MAXTOR1240 RAID5  TAPE DAT
#	CABINET 01 BP D S 14 ENET 
#
# Output file:
#	Ascii file containing complete info about Paragon H/W
#
# Modification History:
#
# $Log: merge.awk,v $
# Revision 1.6  1994/08/19  20:51:29  mouli
# Added 2-row documentation.
#
# Revision 1.3  1993/03/22  01:40:24  mouli
# The script used to output devices on the same line as BP keyword
# due to the bug in reinitilizing slot number and backplane when crossing
# cabinet boundaries.
#
# Revision 1.2  1993/03/18  21:28:22  mouli
# 1. Modified to handle cable-label (A..D) instead of backplane number.
# 2. The device described is a TAPE, the last field that describes
#    the device name (example: DAT) is output.
#
# Revision 1.1  1993/03/12  01:32:58  mouli
# Initial revision
#
# 	03/09/93	mouli	Initial version
#
# Initialize cabinet, bp, slot
# Backplanes are treated as alpha 
BEGIN {
	mcab = -1
	mbp = ""
	ms = -1
	DISK_KWD = "DISK"
	TAPE_KWD = "TAPE"

	SPECIAL_CAB = -01
        SPECIAL_BP  = "-A"
        SPECIAL_SLOT = -01
}
#
# For each device found in the modified device conf file
# find a corresponding entry in the h/w config ascii file
# and append the necessary device info to the slots.
# Those lines that we don't know about, just dump them out.
# Generate output to stdout.
{
	if (length($0) == 0) next
	cab = int($2)
	bp  = $4
	s   = int($6)
	if (cab == SPECIAL_CAB && bp == SPECIAL_BP && s == SPECIAL_SLOT)
	  {
#           Cabinet rows for multi-row system (2-row) output
#           the CAB_ROWS and the number of rows
	    printf "%s %s\n", $7, $8
	    next
	  }
	dev = ""
	for (i = 7; i <= NF; i++)
	{
#	Save the DISK manufacturer's name/devname  for OS instead of the keyword
		if ($i != DISK_KWD && $i != TAPE_KWD)
			dev = dev " "  $i
	}
	while (getline <master)
	{
		if ($1 == "CABINET") 
		{
			mcab = int($2)
			ms = -1
			mbp = ""
#
		}
		else if ($1 == "BP")
		{
			mbp = $2
			ms = -1
		}
		else if ($1 == "S")
		{
			ms = int($2)
		}
#		printf "cab = %d, bp = %s, s = %d, dev = %s\n", cab, bp, s, dev
#		printf "mcab = %d, mbp = %s, ms = %d\n", mcab, mbp, ms
		if (mcab == cab && mbp == bp && ms == s)
		{
			printf "%s %s\n", $0, dev
			break;
		}
		else {
			print $0
		}
	}
}
# We may have left some lines in h/w config file. Dump them.
# 
END {
	while (getline <master)
		print $0
}
