/* m68901.h - Motorola MC68901 MFP (Multi-Function Peripheral) */

/*
modification history
--------------------
01b,04may88,gae  fixed name on banner.
01a,30apr88,gae	 extracted from mv133.h.
*/

#ifndef	INCm68901h
#define	INCm68901h

/* register definitions */

#define MFP_GPIP(base)  ((char *)((base)+0x01))    /* Data I/O port */
#define MFP_AER(base)	((char *)((base)+0x03))    /* active edge register */
#define MFP_DDR(base)	((char *)((base)+0x05))    /* data direction reg. */
#define MFP_IERA(base)  ((char *)((base)+0x07))    /* interrupt enable reg A */
#define MFP_IERB(base)  ((char *)((base)+0x09))    /* interrupt enable reg B */
#define MFP_IPRA(base)  ((char *)((base)+0x0b))    /* int. pending reg A */
#define MFP_IPRB(base)  ((char *)((base)+0x0d))    /* int. pending reg B */
#define MFP_ISRA(base)  ((char *)((base)+0x0f))    /* int. in-service reg A */
#define MFP_ISRB(base)  ((char *)((base)+0x11))    /* int. in-service reg B */
#define MFP_IMRA(base)  ((char *)((base)+0x13))    /* interrupt mask reg A */
#define MFP_IMRB(base)  ((char *)((base)+0x15))    /* interrupt mask reg B */
#define MFP_VR(base)	((char *)((base)+0x17))    /* vector reg */
#define MFP_TACR(base)  ((char *)((base)+0x19))    /* timer A control reg */
#define MFP_TBCR(base)  ((char *)((base)+0x1b))    /* timer B control reg */
#define MFP_TCDCR(base) ((char *)((base)+0x1d))    /* timers B&C control reg */
#define MFP_TADR(base)  ((char *)((base)+0x1f))    /* timer A data reg */
#define MFP_TBDR(base)  ((char *)((base)+0x21))    /* timer B data reg */
#define MFP_TCDR(base)  ((char *)((base)+0x23))    /* timer C data reg */
#define MFP_TDDR(base)  ((char *)((base)+0x25))    /* timer D data reg */
#define MFP_SCR(base)	((char *)((base)+0x27))    /* sync char reg */
#define MFP_UCR(base)	((char *)((base)+0x29))    /* USART control reg */
#define MFP_RSR(base)	((char *)((base)+0x2b))    /* receiver status reg */
#define MFP_TSR(base)	((char *)((base)+0x2d))    /* transmitter status reg */
#define MFP_UDR(base)   ((char *)((base)+0x2f))    /* USART data reg */

/* vector number offsets */

#define MFP_INT_GP0		0x00		/* general purpose I0 */
#define MFP_INT_GP1		0x01		/* general purpose I1 */
#define MFP_INT_GP2		0x02		/* general purpose I2 */
#define MFP_INT_GP3		0x03		/* general purpose I3 */
#define MFP_INT_TIMER_D		0x04		/* timer D */
#define MFP_INT_TIMER_C		0x05		/* timer C */
#define MFP_INT_GP4		0x06		/* general purpose I4 */
#define MFP_INT_GP5		0x07		/* general purpose I5 */
#define MFP_INT_TIMER_B		0x08		/* timer B */
#define MFP_INT_TX_ERR		0x09		/* transmit error */
#define MFP_INT_TRANS		0x0a		/* transmit buffer empty */
#define MFP_INT_RX_ERR		0x0b		/* receive error */
#define MFP_INT_RECV		0x0c		/* receive buffer full */
#define MFP_INT_TIMER_A		0x0d		/* timer A */
#define MFP_INT_GP6		0x0e		/* general purpose I6 */
#define MFP_INT_GP7		0x0f		/* general purpose I7 */

/* bit values for options selected */

#define MFP_TIMER_A		0x20	/* timer A */
#define MFP_TIMER_B		0x01	/* timer B */
#define MFP_TIMER_C		0x20	/* timer B */
#define MFP_TIMER_D		0x10	/* timer B */
#define MFP_RECV_BUFFER_FULL	0x10	/* receiver buffer full */
#define MFP_TRANS_BUFFER_EMPTY	0x04	/* transmitter buffer full */

#endif	INCm68901h
