/* dbc68k.h - Microbar DBC68K2 CPU board header file */

/*
modification history
--------------------
01e,07jun88,gae  added TMR[01]_CLOCK and TMR[01]_FREQ.
01d,29apr88,gae  added BUS and CPU constants.
01c,24may84,dnw  added 8253 timer/counter mode definitions
01b,28jul83,dnw  added definitions for interrupt vector (RR2) of 8274 usart.
01a,18may83,jlf  written
*/

/*
This file contains I/O address and related constants for VxWorks on
the Microbar DBC68K2 CPU board.
*/

#ifndef	INCdbc68k2h
#define	INCdbc68k2h

#define TARGET_UBAR_68K2

#define BUS		MULTI_BUS
#define CPU		MC68000


#define DBC_PIC_0	((char *) 0xefff81)    /* byte 0 of the 8259 */
#define DBC_PIC_1	((char *) 0xefff83)    /* byte 1 */
#define DBC_PPI_A	((char *) 0xefff61)    /* Parallel port A */
#define DBC_PPI_B	((char *) 0xefff63)    /* Parallel port B */
#define DBC_PPI_C	((char *) 0xefff65)    /* Parallel port C */
#define DBC_PPI_CTL	((char *) 0xefff67)    /* Parallel port control */
#define DBC_PIT_0	((char *) 0xefff41)    /* 8253 timer, counter 0 */
#define DBC_PIT_1	((char *) 0xefff43)    /* counter 1 */
#define DBC_PIT_2	((char *) 0xefff45)    /* counter 2 */
#define DBC_PIT_C	((char *) 0xefff47)    /* counter control port */
#define DBC_UD_A	((char *) 0xefff21)    /* 8274 USART data port A */
#define DBC_US_A	((char *) 0xefff25)    /* USART control port A */
#define DBC_UD_B	((char *) 0xefff23)    /* USART data port B */
#define DBC_US_B	((char *) 0xefff27)    /* USART control port B */
#define DBC_MMU		((char *) 0xefff00)    /* Base address of 68451 MMU */

#define N_USART_CHANNELS	2		/* Number of serial channels */

/* Bit values for options selected by WR0 of the 8274 */

#define DBC_U_RST_INT	0x10
#define DBC_U_CHAN_RST	0x18
#define DBC_U_EN_INT	0x20
#define DBC_U_RST_TXINT	0x28
#define DBC_U_ERR_RST	0x30
#define DBC_U_EOI	0x38
#define DBC_U_WR1	0x01	/* Write (read) next byte to (from) WR0 */
#define DBC_U_WR2	0x02
#define DBC_U_WR3	0x03
#define DBC_U_WR4	0x04
#define DBC_U_WR5	0x05

/* Bit values for options selected by WR1b of the 8274 */

#define DBC_U_WAIT_EN		0x80
#define DBC_U_WAIT_RX		0x20
#define DBC_U_WAIT_TX		0x00
#define DBC_U_RX_INT_DIS	0x00
#define DBC_U_RX_INT_SP		0x08
#define DBC_U_RX_INT_PAR	0x10
#define DBC_U_RX_INT_ALL	0x18
#define DBC_U_VAR_VEC		0x04
#define DBC_U_TX_INT_EN		0x02
#define DBC_U_EXT_INT_EN	0x01

/* Bit values for options selected by WR2a of the 8274 */

#define DBC_U_SYNDET	0x80		/* Makes pin 10 be SYNDET* */
#define DBC_U_VEC_INT	0x20		/* Vectored interrupt */
#define DBC_U_8085_1	0x00		/* 8085 mode 1 */
#define DBC_U_8085_2	0x08		/* 8085 mode 2 */
#define DBC_U_8086	0x10		/* 8086 mode */
#define DBC_U_PRI_1	0x04		/* RxA > RxB > TxA > TxB */
#define DBC_U_PRI_2	0x00		/* RxA > TxA > RxB > TxB */
#define DBC_U_BOTH_INT	0x00		/* channel a and b both interrupt */
#define DBC_U_B_INT	0x01		/* a dma, b int */
#define DBC_U_BOTH_DMA	0x02		/* both channels dma */

/* The following are bit values for options selected by WR3 of the 8274 USART */

#define DBC_U_R_5_BITS	0x00
#define DBC_U_R_6_BITS	0x80
#define DBC_U_R_7_BITS	0x40
#define DBC_U_R_8_BITS	0xc0
#define DBC_U_AUTO_EN	0x20
#define DBC_U_RX_EN	0x01

/* Bit values for options selected by WR4 of the 8274 */

#define DBC_U_X1	0x00		/* x1 clock */
#define DBC_U_X16	0x40
#define DBC_U_X32	0x80
#define DBC_U_X64	0xc0
#define DBC_U_SYNC_EN	0x00
#define DBC_U_1_STOP	0x04		/* 1 stop bit */
#define DBC_U_2_STOP	0x0c		/* 2 stop bits */
#define DBC_U_PAR_EVEN	0x02
#define DBC_U_PAR_ODD	0x00
#define DBC_U_PAR_EN	0x01

/* Bit values for options selected by WR5 of the 8274 */

#define DBC_U_DTR	0x80		/* Set DTR bit */
#define DBC_U_T_5_BITS	0x00
#define DBC_U_T_6_BITS	0x40
#define DBC_U_T_7_BITS	0x20
#define DBC_U_T_8_BITS	0x60
#define DBC_U_SEND_BR	0x10		/* Send a break char */
#define DBC_U_TX_EN	0x08
#define DBC_U_RTS	0x02		/* Set RTS bit */

/* Bit values for interrupt vector in RR2 of the 8274 */

#define DBC_U_INT_A	0x04		/* Channel A interrupt */
#define DBC_U_INT_TYPE	0x03		/* Mask for interrupt cause */
#define DBC_U_INT_TX	0x00		/* Transmit buffer empty interrupt */
#define DBC_U_INT_EXT	0x01		/* Ext/status change interrupt */
#define DBC_U_INT_RX	0x02		/* Receive char available interrupt */
#define DBC_U_INT_SPEC	0x03		/* Special Rx condition interrupt */

/* Vector addresses */

#define DBC_U_VEC_TB	(IV_CO + 0x00)
#define DBC_U_VEC_EXTB	(IV_CO + 0x04)
#define DBC_U_VEC_RB	(IV_CO + 0x08)
#define DBC_U_VEC_SPB	(IV_CO + 0x0c)
#define DBC_U_VEC_TA	(IV_CO + 0x10)
#define DBC_U_VEC_EXTA	(IV_CO + 0x14)
#define DBC_U_VEC_RA	(IV_CO + 0x18)
#define DBC_U_VEC_SPA	(IV_CO + 0x1c)

/* 8253 timer/counter modes */

#define TMD_TERMINAL_COUNT	0
#define TMD_ONE_SHOT		1
#define TMD_RATE_GENERATOR	2
#define TMD_SQUARE_WAVE		3
#define TMD_SW_STROBE		4
#define TMD_HW_STROBE		5

#define TMR0_CLOCK	0		/* hardware timer 0 used for clock */
#define TMR1_CLOCK	1		/* hardware timer 1 used for clock */
#define	TMR0_FREQ	1228800		/*  1.23 MHz. */
#define	TMR1_FREQ	153600		/* 153.6 KHz. */

#endif	INCdbc68k2h
