/* pic_cpu.c - Mizar mz7122 and mz7124 jumpering */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
01b,11aug88,gae  added EPROM socket numbers.
01a,25jul87,gae  written.
*/

/*
This module contains the jumpering of the Mizar mz7122 and mz7124.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    printAt (pic, 34, 1, "mz7122/4");

    jumperAt (pic, 15, 4, 1, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  15, 3, "K5 SYSCON");

    jumperAt (pic, 15, 5, 1, HORIZONTAL, VERTICAL, 0x1);
    printAt (pic,  15, 6, "K4 BERR");

    printAt (pic,  35, 7, "XX");
    printAt (pic,  35, 8, "..");
    printAt (pic,  35, 9, "K3 27512");

    printAt (pic, 30, 11, " -------  ------- ");
    printAt (pic, 30, 12, "|  ROM  ||  ROM  |");
    printAt (pic, 30, 13, "|       ||       |");
    printAt (pic, 30, 14, "|  LOW/ || HIGH/ |");
    printAt (pic, 30, 15, "|  ODD  || EVEN  |");
    printAt (pic, 30, 16, "|  U16  || U15   |");
    printAt (pic, 30, 17, " ---^---  ---^--- ");
    }
