/* mv147/config.h - Motorola MVME-147 configuration header */

/*
modification history
--------------------
*/

/*
This module contains the parameters that define the configuration
for the MVME-147.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "mv147.h"
#include "if_bp.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"ln(0,0)host:/usr/vw/config/mv147/vxWorks h=90.0.0.3 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
#define	INCLUDE_1.5COMPAT		/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DBX		/* DBX debugger */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_LN		/* include MVME-147 LANCE Ethernet interface */

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_ENP		/* include CMC Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100

#define NV_RAM_SIZE	NV_BOOT_LINE_SPACE	
#define SYS_CPU_FREQ    20000000        /* 20 MHz system clock */

#define IO_ADRS_LN ((char *) 0xfffe1800) /* 32A,32D MVME-147 LANCE Ethernet */ 

/* interrupt vectors */
#define INT_VEC_ACFAIL          (PCC_INT_VEC_BASE + PCC_INT_ACFAIL)
#define INT_VEC_BERR            (PCC_INT_VEC_BASE + PCC_INT_BERR)
#define INT_VEC_ABORT           (PCC_INT_VEC_BASE + PCC_INT_ABORT)
#define INT_VEC_SCSI            (PCC_INT_VEC_BASE + PCC_INT_SCSI)
#define INT_VEC_SCSI_DMA        (PCC_INT_VEC_BASE + PCC_INT_SCSI_DMA)
#define INT_VEC_LP              (PCC_INT_VEC_BASE + PCC_INT_PRINTER)
#define INT_VEC_CLOCK           (PCC_INT_VEC_BASE + PCC_INT_TIC_1)
#define INT_VEC_AUX_CLOCK       (PCC_INT_VEC_BASE + PCC_INT_TIC_2)
#define INT_VEC_LN              (PCC_INT_VEC_BASE + PCC_INT_LANCE)
					/* MVME147 LANCE Ethernet controller */
					 
#define INT_LVL_LP              1       /* printer interface */
#define INT_LVL_TIC_1           6       /* system clock is tic 1 */
#define INT_LVL_TIC_2           5       /* aux clock is tic 2 */
#define INT_LVL_TY              4       /* tyCoDrv interface (4 serial lines)*/ 
#define INT_LVL_LN              3       /* MVME147 LANCE Ethernet controller */

/* backplane network parameters */

#define	BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS  ((char *) (0x00800000))   /* bp anchor adrs */
#else
#define	BP_ANCHOR_ADRS  ((char *) (0x00000600))   /* bp anchor adrs */
#endif	BP_OFF_BOARD
 
#define BP_INT_TYPE     BP_INT_MAILBOX_1        /* (signal hp) interrupt */
#define BP_INT_ARG1     VME_AM_SUP_SHORT_IO     /* bus address space */
#define BP_INT_ARG2     ((sysProcNum << 4) + 3) /* bus adrs */
#define BP_INT_ARG3     2                       /* value (SIGHP bit */
  
/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */
    
#if	BP_OFF_BOARD
#define BP_MEM_ADRS     BP_ANCHOR_ADRS	/* bp shared mem adrs */
#define BP_MEM_SIZE     0x80000		/* 512k */
#else
#define BP_MEM_ADRS     NONE          	/* NONE = allocate from memory */
#define BP_MEM_SIZE     0x10000		/* 64k */
#endif	BP_OFF_BOARD
     

/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-147 local memory address always appears at 0 locally;
 * its address on the bus is set by the RAM_BASE register in the PCC.
 */
     
#define LOCAL_MEM_LOCAL_ADRS    0               /* fixed */
#define LOCAL_MEM_SIZE          (0x400000)	/* 4 MBytes */
#define LOCAL_MEM_BUS_ADRS      (2*LOCAL_MEM_SIZE) /* only for processor 0 */
				     /* must be multiple of memory size */

#define NV_BOOT_LINE            ((char *) (BBRAM + 0x100))
#define NV_BOOT_LINE_SPACE      (0x100)         /* reserve 256 bytes in BBRAM */

/* Base address of the on-board rom */

#define ROM_BASE_ADRS           0xff800000                          

#endif	INCconfigh
