/* mv135.h - MVME-135 CPU board header file */

/*
modification history
--------------------
01d,31aug88,gae  fixed MPCSR_BUS_ADRS calculation, thanks to Benny Schnaider.
01c,13jun88,gae  removed superfluous (char)'s and added CNT5_INIT for
		 assembler.
01b,03may88,gae  added INCmv135h.
01a,09feb88,ak   created by modifying 01d of mv133.h
*/

/*
This file contains I/O address and related constants for the MVME-135.
*/

#ifndef	INCmv135h
#define	INCmv135h

#include "z8036.h"
#include "m68681.h"

#define TARGET_MV135
#define BUS		VME_BUS
#define CPU		MC68020

/******************* interrupt vector locations ********************/

/* as defined by mv135 spec */
#define ABORT_INT_VEC	0x40		/* abort pushbutton */
#define ACFAIL_INT_VEC	0x41		/* vme bus acfail line */
#define CIO_INT_VEC	0x42		/* Z8036 timer chip int */
#define SFIRQ_INT_VEC	0x43		/* vmebus sysfail line */
#define SIO_INT_VEC	0x44		/* duart tty int vector base num */
#define SIGHP_INT_VEC	0x45		/* high priority mailbox int */
#define VSB_INT_VEC	0x47		/* VSB chip/bus */
#define LM_INT_VEC	0x4a		/* location monitor */
#define SIGLP_INT_VEC	0x4b		/* low priority mailbox int */

/* as defined by us */
#define CIO_TIM_VEC	0x50		/* we set z8036 chip to go here */

/************* device control/status register addresses **********************/

#define VSB_CSR_ADRS    ((char *) 0xfffa0000) /* vsb control/status */
#define CIO_ADRS	((char *) 0xfffb0000) /* z8035 timer chip */
#define STAT1_ADRS      ((char *) 0xfffb000d) /* status register 1 --
					       * front panel switches */
#define STAT2_ADRS      ((char *) 0xfffb0032)
#define CNT1_ADRS       ((char *) 0xfffb000e) /* control register 1 */
#define CNT2_ADRS       ((char *) 0xfffb0038)
#define CNT3_ADRS       ((char *) 0xfffb0039)
#define CNT4_ADRS       ((char *) 0xfffb003a)
#define CNT5_ADRS	((char * ) 0xfffb003b)
#define CNT5_ADRS_ASM	0xfffb003b	/* assembler doesn't like (char *) */
#define SIO_ADRS	((char *) 0xfffb0040) /* duart */
#define MPCSR_ADRS      ((char *) 0xfffb0060) /* multi processor cntrl/status
					       * region local address */

/************************** bit fields ************************************/
/* STAT2 status flag bits */
#define STAT2_LCLERR    0x01	/* local device timeout when low */
#define STAT2_MMUBER    0x02	/* mmu bus error when 0 */
#define STAT2_VSBERR    0x04	/* vsb bus error */
#define STAT2_VBERR     0x08	/* vme bus error (when we are master)*/
#define STAT2_SYSFAIL   0x10	/* VME bus SYSFAIL signal received */
#define STAT2_ABORT     0x20	/* ABORT pushbutton status */
#define STAT2_RMCERR    0x40	/* read/modify cycle in bus err */
#define STAT2_RAMERR    0x80	/* local dram parity err in bus err */

/* these are bit masks for control registers */
#define CNT1_VSBIEN     0x10	/* enables VSBIRQ interrupts */
#define CNT1_PAREN      0x20	/* enable parity fault bus errors */
#define CNT1_WWP        0x40	/* write wrong parity */
#define CNT1_BRIRQI     0x80	/* interrupt all Z8036 timers */
#define CNT2_VMSK       0x01	/* if 0, no VME access to local mem */
#define CNT2_VBIMSK     0x02	/* 7-bit fields; if 0, respond
					   to corresponding VMEbus IRQ */
#define CNT3_VSBIRQO    0x01	/* if 0, generate diagnostic VSB int */
#define CNT3_BRIQO      0x02	/* if 0broadcast VME IRQ1  */
#define CNT3_LMIEN      0x04	/* if 0, enable MPCSR location
					   monitor 0 interrupt */
#define CNT3_SLPIEN     0x08	/* if 0 enable MPCSR SIGLP int */
#define CNT3_SHPIEN     0x10	/* if 0, enable MPCSR SIGHP int */
#define CNT3_SYSFIEN    0x20	/* enable local SYSFIRQ system
					   fail interrupt report, if 0 */
#define CNT3_ALLIEN     0x40	/* if 1, all interrupts are disabled */
#define CNT3_BUSY       0x80	/* software usable busy flag */
#define	CNT3_INIT \
    (CNT3_SYSFIEN + CNT3_SHPIEN + CNT3_SLPIEN + CNT3_LMIEN + \
     CNT3_BRIQO + CNT3_VSBIRQO)

#define CNT4_GLBRES	0x80	/* when low causes 200 msec sys reset*/

#define CNT5_BDFAIL     0x01	/* if 1, generates VME SYSFAIL int */
#define CNT5_32_16      0x02	/* if 1, allow 32 bit VME references */
#define CNT5_32_24      0x04	/* if 0, mixed 24/32 bit VME
					   addresses  */
#define CNT5_OPT0       0x08	/* if 1, local ram appears at
					   0 as well as ffe00000 */
#define CNT5_VTMO       0x10	/* enables VME timeout generator */
#define CNT5_LTMO       0x20	/* enables local timeout generator */
#define CNT5_WD1        0x40	/* 2 bits control events if */
#define CNT5_WD0	0x80    /* watch dog timer times out  */

#define	CNT5_INIT \
    (CNT5_WD0 + CNT5_WD1 + CNT5_LTMO + CNT5_VTMO + CNT5_OPT0 + CNT5_32_16)

/* VSB bus CSR bits offsets */
#define VSBCSR_SCON             0x01	/* make us the VSB system cntrlr */
#define VSBCSR_BLOCKEN          0x02	/* enable block transfer */
#define VSBCSR_10               0x04	/* if 1, mc68010 mode */
#define VSBCSR_VSBDEN           0x08	/* vsb decode enable */
#define VSBCSR_READONLY		0x10	/* prevents us writing over vsb */
#define VSBCSR_VSBEN            0x20	/* enable master mode */
#define VSBCSR_ENTO0            0x80	/* enable timeout option 0 */
#define VSBCSR_ENTO1            0x0100	/* enable timeout option 1 */
#define VSBCSR_ROBIN		0x0200	/* round robin bus arb */
#define VSBCSR_WRERROR		0x0400	/* reports write to read only bus */
#define VSBCSR_TIMEOUT		0x0800	/* reports bus timeout */
#define VSBCSR_ASACK0		0x1000	/* address amd size status 0 */
#define VSBCSR_ASACK1		0x2000	/* address amd size status */
#define VSBCSR_ERR		0x4000	/* reports VSB bus error */

/* multi processor control and status registers byte & bit offsets */
#define MPCSR_ID(addr)  	((char *) addr + 0x01)
			 /* controls vme addr of this status region */
#define MPCSR_FLAGS(addr)	((char *) addr + MPCSR_ADRS 0x03)
			 /* see below for bit fields */
#define MPCSR_LM(addr)  	((char *) addr + 0x05)
			 /* location monitor bit fields */
	/* bit offsets follow */
#define MPCSR_LM_KING  0x80	/* module not disqualified as
				   system initializer */
#define MPCSR_RH(addr)		((char *) addr + 0x07)	/* 2 bit fields */
#define MPCSR_RH_RH    0x80	/* allows another bus master
				   to reset and hold us */
#define MPCSR_RONR     0x08	/* forces round robin bus
				   arbitration of masters with
				   same VME bus request level */
#define MPCSR_HH(addr)        	((char *) addr + 0x09)
			 /* allows another bus master to suspend us */
/* these next 2 are mailbox interrupts */
#define MPCSR_SIGLP(addr)     	((char *) addr + 0x0b)
			 /* signal low priority generates level 2 int
			  * maskable by CNTL3_SLPIEN */
#define MPCSR_SIGHP(addr)     	((char *) addr + 0x0d)
			 /* signal high priority generates level 5 int
			  * maskable by CNTL3_SHPIEN*/
#define MPCSR_MP0(addr)       	((char *) addr + 0x11)
			 /* top bit is a multi-proc semaphore */
#define MPCSR_MP1(addr)       	((char *) addr + 0x13)
			 /* top bit is a multi-proc semaphore */
#define MPCSR_MP2(addr)       	((char *) addr + 0x15)
			 /* top bit is a multi-proc semaphore */
#define MPCSR_MP3(addr)       	((char *) addr + 0x17)
			 /* top bit is a multi-proc semaphore */
#define MPCSR_MPCOMM(addr)    	((char *) addr + 0x19)
			 /* byte for multi-proccessor message passing  */

#define MPCSR_BUS_ADRS  (((*MPCSR_ID(MPCSR_ADRS) & 0x1f) << 5) | \
			((*MPCSR_ID(MPCSR_ADRS) & 0xe0) << 8))

/* MPCSR_FLAG bit fields (read only, for remote processors) */
#define MPCSR_FLAG_BSY  0x80	/* tells others were not ready */
#define MPCSR_FLAG_SCON 0x40	/* establishes system controller */
#define MPCSR_FLAG_FAIL 0x20	/* tells others if we
					   experienced BDFAIL */
#define MPCSR_FLAG_WDT  0x10	/* tells others if we
					   experienced watchdog timer reset */

/* MPCSR_LM bit fields */
#define MPCSR_LM_2      0x40
#define MPCSR_LM_1      0x20
#define MPCSR_LM_0      0x10	/* this location monitor bit
				   may generate a location
				   monitor int */
#define MPCSR_ISF       0x80	/* inhibit sys fail */
#define MPCSR_LKTR      0x40	/*  causes next VME access to
					    lock the bus */

/* SIO -- m68681 serial channel chip -- register definitions
 * -- for gritty bit field definitions, see m68681.h, 
 * which must be included in any file that includes this file  */

#define DUART_MRA	(SIO_ADRS + 0x00)	/* mode reg. A */
#define DUART_CSRA	(SIO_ADRS + 0x01)	/* clock select reg. A */
#define DUART_SRA	DUART_CSRA		/* status reg. A */
#define DUART_CRA	(SIO_ADRS + 0x02)	/* command reg. A */
#define DUART_THRA	(SIO_ADRS + 0x03)	/* transmit buffer A */
#define DUART_RHRA	DUART_THRA		/* receive buffer A */
#define DUART_ACR	(SIO_ADRS + 0x04)	/* auxiliary control reg. */
#define DUART_IPCR	DUART_ACR		/* input port change reg. */
#define DUART_IMR	(SIO_ADRS + 0x05)	/* int. mask reg. */
#define DUART_ISR	DUART_IMR		/* int. status reg. */
#define DUART_CTUR	(SIO_ADRS + 0x06)	/* counter timer upper reg. */
#define DUART_CTLR	(SIO_ADRS + 0x07)	/* counter timer lower reg. */
#define DUART_MRB	(SIO_ADRS + 0x08)	/* mode reg. B */
#define DUART_CSRB	(SIO_ADRS + 0x09)	/* clock select reg. B */
#define DUART_SRB	DUART_CSRB		/* status reg. B */
#define DUART_CRB	(SIO_ADRS + 0x0a)	/* command reg. B */
#define DUART_THRB	(SIO_ADRS + 0x0b)	/* transmit buffer B */
#define DUART_RHRB	DUART_THRB		/* receive buffer B */
#define DUART_IVR	(SIO_ADRS + 0x0c)	/* int. vector reg. */
#define DUART_OPCR	(SIO_ADRS + 0x0d)	/* output port config. reg. */
#define DUART_IP	DUART_OPCR		/* input port */
#define DUART_SOPBC	(SIO_ADRS + 0x0e)	/* set output port bits */
#define DUART_CTRON	DUART_SOPBC		/* counter on */
#define DUART_ROPBC	(SIO_ADRS + 0x0f)	/* reset output port bits */
#define DUART_CTROFF	DUART_ROPBC		/* counter off */

#endif	INCmv135h
