/* mv133/config.h - MVME-133/133A/133XT/134 configuration header */

/*
modification history
--------------------
*/

/*
This module contains the parameters that define the configuration
for the MVME-133, MVME-133A, MVME-133XT and the MVME-134 boards.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "mv133.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mv133/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
#define	INCLUDE_1.5COMPAT		/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DBX		/* DBX debugger */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100

#define NV_RAM_SIZE	RTC_RAM_SIZE	/* has 2040 bytes of non-volatile RAM */


/* Device controller I/O addresses:
*  MVME-133 & MVME-133A can't have 0x00800000 bit set
*/

#define IO_ADRS_EX	((char *) 0x007f0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_NW	((char *) 0x00780000)	/* 24A,32D ISI Ethernet */


/* interrupt vectors */

#define INT_VEC_CLOCK		(MFP_INT_VECT_NUM + MFP_INT_TIMER_A)


/* backplane network parameters */

#define	BP_OFF_BOARD	TRUE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0x00800000))	/* off-board bp anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) (0x00000600))	/* on-board bp anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_NONE		/* no bp interrupt */
#define BP_INT_ARG1	0			/* unused */
#define BP_INT_ARG2	0			/* unused */
#define BP_INT_ARG3	0			/* unused */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x80000		/* 512k */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE	0x10000		/* 64k */
#endif	BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the MVME-133 local memory address always appears at 0 locally;
 * its address on the bus is set by jumpers.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* jumpers */

/* Base address of the on-board rom */
 
#define ROM_BASE_ADRS		0xfff00000

#endif	INCconfigh
