/* romInit.s - init module for code in rom, MV131 version */

/*
modification history
--------------------
01b,19nov87,dnw changed to use ROM_BASE_ADRS in config.h.
01a,16nov87,jcf	romInit2 now takes an argument from sysToMonitor
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */



/***********************************************************************
*
* romInit1 -

* romInit1 ()

*/

romInit1:
	moveq	#BOOT_COLD,d3		/* indicate initial in rom */
	bra	romInitCom

romInit2:
	link	a6,#0			/* no unlk necessary; we change stacks*/
	movel	a6@(0x08),d3		/* put startType in d3 */

romInitCom:
	moveb	#0x38,0xfffb003b	/* enable vmx bus */

	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	movel	#0x09,d0	/* clear and enable cache */
	.word	0x4e7b		/* movec ... 			*/
	.word	0x0002		/* .....	d0,cacr 	*/


	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7	/* set stack to start of code */
	movel	d3,a7@-		/* push arg = start type */
	jsr	_usrInit	/* never returns - just starts up kernel */

