/* pic_cpu.c - Ironics IV-1624A jumpering */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
modification history
--------------------
01d,12jul88,gae  fixed name to IV-1624A.  fixed ROM sockets.
		 Added software jumpers indicating 10/12 Mhz.
01c,04apr88,gae  removed call to printPic().
01b,16mar88,gae  renamed from pic_iv24.c for new jump.
01a,07nov87,jcf  created
*/

/*
This module contains the jumpering of the IV-1624A.
It is only used by jump (4).

SEE ALSO: jump (4)
*/

#include "UniWorks.h"
#include "config.h"
#include "picture.h"


/*******************************************************************************
*
* drawBoard - draw cpu jumper config
*
* ARGSUSED1
*/

VOID drawBoard (pic, interactive)
    char *pic;
    BOOL interactive;

    {
    printAt (pic, 34, 1, "IV-1624A");

    /* bus base address */

    jumperAt (pic, 20, 10, 1, HORIZONTAL, VERTICAL, 0x0);
    printAt (pic, 17,  9, "J8");
    printAt (pic, 22,  9, " -------  ------- ");
    printAt (pic, 22, 10, "|  ROM  ||  ROM  |");
    printAt (pic, 22, 11, "|       ||       |");
    printAt (pic, 22, 12, "|  U43  ||  U44  |");
    printAt (pic, 22, 13, "|       ||       |");
    printAt (pic, 22, 14, "|  ODD  ||  EVEN |");
    printAt (pic, 22, 15, "|---^---||---^---|");

    jumperAt (pic, 54, 3, 3, VERTICAL, VERTICAL, 0x5);
    printAt (pic, 50, 4, "J25");

    printAt (pic, 56, 3, "+-------------+");
    printAt (pic, 56, 4, "|Zilog |      |");
    printAt (pic, 56, 5, "|      |      |");
    printAt (pic, 56, 6, "|------+------|");
    printAt (pic, 56, 7, "|      |4-plex|");
    printAt (pic, 56, 8, "|      |      |");
    printAt (pic, 56, 9, "+-------------+");

    switch (low_byte_bus)
	{
	case 0xd00000:
	    jumperAt (pic, 20, 10, 1, HORIZONTAL, VERTICAL, 0x1);
	    jumperAt (pic, 54, 3, 3, VERTICAL, VERTICAL, 0x7);
	    break;

	case 0xd80000:
	    jumperAt (pic, 54, 3, 3, VERTICAL, VERTICAL, 0x7);
	    break;

	case 0xe00000:
	    jumperAt (pic, 20, 10, 1, HORIZONTAL, VERTICAL, 0x1);
	    break;

	default:
	    break;
	}

    /* PCL status lines: software switches
     *   J10 = bit 1 ON ==> 12Mhz
     */

    printAt (pic, 71,  7, "J13");
    printAt (pic, 71,  8, "J12");
    printAt (pic, 71,  9, "J11");
    printAt (pic, 71, 10, "J10 ?");
    printAt (pic, 69, 11, "L=12Mhz");
    printAt (pic, 69, 12, "R=10Mhz");

    /* miscellaneous */

    jumperAt (pic, 50, 17, 1, VERTICAL, VERTICAL, 0x1);
    printAt (pic, 52, 17, "J1");
    printAt (pic, 22, 16, "L. J3");
    printAt (pic, 22, 17, ".R J2");
    }
