/* vrtxLib.c - internal UniWorks/VRTX kernel library */

static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This module contains internal support routines for the UniWorks/VRTX interface.

SEE ALSO: vrtxALib (1)
*/

#include "UniWorks.h"

#if (CPU == MC68020)
#include "vrtx32.h"
#else (CPU != MC68020)
#include "vrtx.h"
#endif (CPU)


/*******************************************************************************
*
* vxGetFreeTaskId - get a free task id
*
* This routine finds a task id not currently used by any task.
* Note however that the returned task id is not "reserved" in any way
* and could conceivably be used by some other spawner before the caller
* gets around to using it.  For this reason, it is better to
* call taskSpawn (2) with a NULL task name so that one will be assigned.
*
* This routine looks forward from task id 1 to task id 255 for an unused id.
*
* RETURNS: unused task id, or ERROR if none available
*
* NOMANUAL
*/

int vxGetFreeTaskId ()

    {
    int ix;		/* task number index */
    int dummy;		/* filled in, but not used */
    VX_TCB *pTcb;	/* filled in, but not used */

    for (ix = 1; ix <= 255; ++ix)
	{
	if (vxTinquiry (ix, &dummy, &dummy, &dummy, &pTcb) == ERROR &&
	    errnoGet () == S_vrtx_TASK_ID_ERROR)
	    {
	    return (ix);		/* found a free TID */
	    }
	}

    errnoSet (S_taskLib_NO_FREE_TASK_ID);
    return (ERROR);		/* couldn't find free task id !! */
    }
/*******************************************************************************
*
* idle - idle task
*
* This task is created at lowest priority.  We drop to here if
* nothing else to do.
*
* NOMANUAL
*/

VOID idle ()

    {
    FOREVER;
    }
