/* tickLib.c - VxWorks/VRTX clock tick support library */

static char *copyright = "Copyright 1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This library provides a generic interface to VRTX kernel time management.
This includes:

    - announce a timer tick to VRTX,
    - get the current time in ticks,
    - set the current time in ticks.

SEE ALSO: "Architecture", taskLib (1), kernelLib (1)
*/

/* LINTLIBRARY */

#include "UniWorks.h"

IMPORT ULONG vxGTime ();


/*******************************************************************************
*
* tickAnnounce - annouce a clock tick to VRTX
*
* This routine is used to inform VRTX of the passing of time.
* It should be called from an interrupt service routine that is
* connected to the system clock.
*
* SEE ALSO: vxTimer (2)
*/

VOID tickAnnounce ()

    {
    vxTimer ();
    }
/*******************************************************************************
*
* tickSet - set value of VRTX's tick counter
*
* SEE ALSO: tickGet (2), vxStime (2)
*/

VOID tickSet (ticks)
    ULONG ticks;	/* new time in ticks */

    {
    vxStime (ticks);
    }
/*******************************************************************************
*
* tickGet - get value of VRTX's tick counter
*
* RETURNS: value of the VRTX clock
*
* SEE ALSO: tickSet (2), vxGtime (2)
*/

ULONG tickGet ()

    {
    return (vxGtime());
    }
