/* vxALib.s - miscellaneous support routines */

/*
modification history 
--------------------
01c,05jun88,dnw  changed from kALib to vxALib.
01b,30may88,dnw  changed to v4 names.
01a,15mar88,jcf  written and soon to be redistributed.
*/

/*
DESCRIPTION
*/

#define ASMLANGUAGE
#include "UniWorks.h"

	.text
	.even

	/* internals */

#if (CPU!=MC68030)
	.globl _vxMemProbeSup
	.globl _vxMemProbeTrap
#else
	.globl	_vx030Probe
#endif
	.globl _vxTas		


	/* externals */

	.globl _sysKernelTrap
	.globl _exit


/* a6 offsets to arguments */

#define ARG1	8
#define ARG1W	10
#define ARG2	12
#define ARG2W	14
#define ARG3	16
#define ARG3W	18
#define ARG4	20
#define ARG5	24
#define ARG6	28
#define ARG7	32

	.text
	.even

#if (CPU!=MC68030)
/*******************************************************************************
*
* vxMemProbeSup - vxMemProbe support routine
*
* This routine is called to try to read byte, word, or long, as specified
* by length, from the specified source to the specified destination.
*
* vx030Probe is used for boards with a 68030 processor
*
* NOMANUAL

* STATUS vxMemProbeSup (length, src, dest)
*     int length;	/* length of cell to test (1, 2, 4) *
*     char *src;	/* address to read *
*     char *dest;	/* address to write *

*/

_vxMemProbeSup:
	link	a6,#0

	movel	a6@(ARG2),a0	/* get source address */
	movel	a6@(ARG3),a1	/* get destination address */

	clrl	d0		/* preset status = OK */

	movel	a6@(ARG1),d1	/* get length */
	cmpl	#1,d1
	bne	vmp10
	moveb	a0@,a1@		/* move byte */
	bra	vmpRtn

vmp10:
	cmpl	#2,d1
	bne	vmp20
	movew	a0@,a1@		/* move word */
	bra	vmpRtn

vmp20:
	movel	a0@,a1@		/* move long */

	/* NOTE: vmpRtn is known by vxMemProbTrap for 68000 because 68000
	 * can't know where to return exactly. */
vmpRtn:
	unlk	a6
	rts


/*******************************************************************************
*
* vxMemProbeTrap - vxMemProbe support routine
*
* This entry point is momentarily attached to the bus error exception vector.
* It simply sets d0 to ERROR to indicate that
* the bus error did occur, and returns from the interrupt.
*
* 68010 & 68020 NOTE:
* The instruction that caused the bus error must not be run again so we
* have to set some special bits in the exception stack frame.
*
* 68000 NOTE:
* On the 68000, the pc in the exception stack frame is NOT necessarily
* the address of the offending instruction, but is merely "in the vicinity".
* Thus the 68000 version of this trap has to patch the exception stack
* frame to return to a known address before doing the RTE.
*
* NOMANUAL
*/

_vxMemProbeTrap:		/* we get here via the bus error trap */

#if (CPU==MC68000)
	addql	#8,a7		/* throw away extra bus error info on stack */
	movel	#vmpRtn,a7@(2)	/* patch return address (see note above) */
#endif

#if (CPU==MC68010)
	/* The special status word needs to have the rr bit set, only
	 * on the 68010.  This prevents the offending instruction from
	 * being run again. */

	moveb	#0x80,d0	/* rr bit is the upper bit */
	orb	d0,a7@(8)	/* Set it in special status register */
#endif

#if (CPU==MC68020)
	/* In the 68020, we reset the RC and RB flags of the special
	 * status word to prevent the bus cycle from being re-run.
	 * We'll also reset the DF flag just in case */

	moveb	#0xce,d0	/* reset bits 4, 5 and 0 */
	andb	d0,a7@(0xa)	/* ssw is always at offset 0xa */
#endif

	movel	#-1,d0		/* set status to ERROR */
	rte			/* return to the subroutine */

#else (CPU==68030)

/*******************************************************************************
*
* vx030Probe - vxMemProbe support routine
*
* This routine is called to try to read byte, word, or long, as specified
* by length, from the specified source to the specified destination.
*
* vx030Probe is used only for boards with a 68030 processor
*
* NOMANUAL
*/

_vx030Probe:
	link	a6,#0

	movel	a6@(ARG2),a0	/* get source address */
	movel	a6@(ARG3),a1	/* get destination address */

	movel	0x8,d0		/* save BERR vector in d0 */
	movel	#v30pberr,0x8

	movel	a6@(ARG1),d1	/* get length */
	cmpl	#1,d1
	bne	v30pw
	moveb	a0@,a1@		/* move byte */
	movel	#4,d1
1:	dbne	d1,1b
	bra	v30pok

v30pw:
	cmpl	#2,d1
	bne	v30pl
	movew	a0@,a1@		/* move word */
	movel	#4,d1
1:	dbne	d1,1b
	bra	v30pok

v30pl:
	movel	a0@,a1@		/* move long */
	movel	#4,d1
1:	dbne	d1,1b

v30pok:				/* we get here if there was NO BERR */
	movel	d0,0x8		/* restore BERR vector */
	clrl	d0		/* set return = 0 */
	unlk	a6
	rts

v30pberr:			/* we get here if there was a BERR */
	movew	a7@(10),d1	/* examine ssw */
	andw	#0xf000,d1	/* if long ESF, then pop 92 bytes off */
	cmpw	#0xa000,d1	/* the stack, otherwise 32 bytes */
	bne	poplong
	addl	#32,a7		/* pop 32 bytes */
	bra	popdone
poplong:	
	addl	#92,a7		/* pop 92 bytes */
popdone:
	movel	d0,0x8		/* restore BERR vector */
	movel	#-1,d0		/* set return = -1 */
	unlk	a6
	rts
#endif (CPU)

/*******************************************************************************
* 
* vxTas - C callable test-and-set primitive
*
* This routine provides a C callable interface to the 680x0 test-and-set
* instruction.  The `tas' instruction is executed on the specified
* address.
*
* RETURNS:
*   TRUE if value had been not set (but now is),
*   FALSE if value was already set.

* BOOL vxTas (address)
*     char *address;		/* address to be tested *

*/
_vxTas:		
	moveq	#0,d0		
	movel	sp@(4),a0
	tas	a0@	
	bne	t1
	addqw	#1,d0		
t1:	rts
