/* bLib.c - buffer subroutine library */

static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This library contains routines to manipulate buffers, which are just
variable length byte strings.
*/

/* LINTLIBRARY */

#include "UniWorks.h"

/*******************************************************************************
*
* invbuf - invert the order of bytes in a buffer
*
* This routine inverts an entire buffer, byte by byte.  For example,
* the buffer {1, 2, 3, 4, 5} would become, after inversion, {5, 4, 3, 2, 1}.
*
*/

VOID invbuf (buf_start, nbytes)
    FAST char *buf_start;	/* pointer to buffer to invert	*/
    int nbytes;			/* number of bytes in buffer	*/

    {
    FAST char *buf_end = buf_start + nbytes - 1;
    FAST char temp;

    while (buf_start < buf_end)
	{
	temp       = *buf_start;
	*buf_start = *buf_end;
	*buf_end   = temp;

	buf_end--;
	buf_start++;
	}
    }
/*******************************************************************************
*
* swpbuf - swap buffers
*
* This routine exchanges the first "nbytes" of the two specified buffers,
* "nbytes" not exceeding 32K.
*/

VOID swpbuf (buf1, buf2, nbytes)
    FAST char *buf1;		/* pointer to buffer 1		*/
    FAST char *buf2;		/* pointer to buffer 2		*/
    FAST int nbytes;		/* number of bytes to swap	*/

    {
    FAST char temp;

    while (--nbytes >= 0)
	{
	temp = *buf1;
	*buf1++ = *buf2;
	*buf2++ = temp;
	}
    }
/*******************************************************************************
*
* swab - swap bytes
*
* This routine swaps "nbytes" pointed to by "from" to the position
* pointed to by "to", exchanging adjacent even and odd bytes.
* If "from" and "to" are the same then the bytes are simply interchanged.
* If "from" and "to" buffers overlap and are not identical this routine is
* unsuitable.  It is an error for "nbytes" to be odd.
*
* SEE ALSO: BSD 4.2 manual entry for swab
*
*/

VOID swab (from, to, nbytes)
    char *from;			/* pointer to source buffer		*/
    char *to;			/* pointer to destination buffer	*/
    int nbytes;			/* number of bytes to exchange		*/

    {
    FAST short *src = (short *) from;
    FAST short *dst = (short *) to;
    FAST short *dst_end = dst + (nbytes / 2);

    for (; dst < dst_end; dst++, src++)
	{
	*dst = ((*src & 0x00ff) << 8) | ((*src & 0xff00) >> 8);
	}
    }

