/* if_qx.c - ISI Liberator/SEEQ8003 network interface */

/*
 * TODO -
 *	1. since there will only be one of these EVER, see if we would gain
 *	anything by making softc & friends into single structures instead of
 *	arrays, and eliminate any code relating to unit numbers.
 *
 * BUGS - 
 *	1. In qxRead rxptr->et_flags is set to 0 before qxget, it should be
 *	set after qxget.
 *
 *	2. ethbuf is declared to be size:
 *
 *		(NQXRXDESC + NQXTXDESC) * (1514 + 2) + 2 bytes
 *
 *	but, OPE_BUFSIZE is declared to be 1520
 */

#define	DEBUG		/**/
#ifdef	DEBUG
int qxrxdebug = 0;
int qxtxdebug = 0;
#endif	DEBUG

#include "UniWorks.h"
#include "vme.h"
#include "param.h"
#include "mbuf.h"
#include "protosw.h"
#include "socket.h"
#include "ioctl.h"
#include "errno.h"
#include "memLib.h"
#include "iv68k.h"

#include "if.h"
#include "route.h"

#include "in.h"
#include "in_systm.h"
#include "in_var.h"
#include "ip.h"
#include "if_ether.h"

#include "if_qxreg.h"
#include "openchip.h"
#include "liberator.h"

#include "sysLib.h"
#include "wdLib.h"
#include "iosLib.h"
#include "etherLib.h"

extern ipintr();
extern struct ifnet loif;

/*
 * Ethernet software status per interface.
 * Each interface is referenced by a network interface structure,
 * qs_if, which the routing code uses to locate the interface.
 */

struct	qx_softc {
	struct	arpcom	qs_ac;		/* common ethernet structures */
#define qs_if		qs_ac.ac_if	/* network-visible interface */
#define qs_addr		qs_ac.ac_enaddr	/* hardware ethernet address */

/*
 * Since the OpenChip Ethernet descriptors must exist on a 16 byte 
 * boundary, a character array is declared which should be at least:
 *
 * 	(NQXRXDESC + NQXTXDESC) * sizeof (struct eth_desc) + 14 bytes
 */

	char ethdesc[(NQXRXDESC+NQXTXDESC) * 16 + 14];

/*
 * Each data buffer must be able to hold a max sized Ethernet packet
 * without FCS i.e. 1514 bytes. The OpenChip microcode requires
 * that each buffer start on a 4 byte boundary, ethbuf must be at least:
 *
 *	(NQXRXDESC + NQXTXDESC) * (1514 + 2) + 2 bytes
 */

	char ethbuf[(NQXRXDESC+NQXTXDESC) * (OPE_BUFSIZE) + 2];

	struct eth_desc *eth_rxptr;	/* current position in ring */
	struct eth_desc *eth_txptr;	/* current position in ring */

	struct qxdevice	*qs_qxdev;	/* device address struct */
	int ivec;
} qx_softc[NQX];

/* Forward declarations */

int qxattach(), qxintr(), qxreset(), qxoutput(), qxread();
int qxinit(), qxstart();
int qxioctl();
struct mbuf *qxget();

/*********************************************************************
*
* qxattach - attach the qx driver to the network
*
*/

STATUS qxattach (unit)
	int unit;

{
	struct qx_softc *qs;
	struct ifnet *ifp;

	qs = &qx_softc[unit];
	ifp = &(qs->qs_if);

	if (get_ethernum(qs->qs_addr) == ERROR)
		return(ERROR);
	intConnect(INUM_TO_IVEC(VEC_ETHERNET),qxintr,unit);

	qs->ivec = VEC_ETHERNET;
	qs->qs_qxdev = (struct qxdevice *) IO_ADRS_QX;

	ifp->if_unit = unit;
	ifp->if_name = "qx";
	ifp->if_mtu = ETHERMTU;
	ifp->if_flags = IFF_BROADCAST;
	ifp->if_init = qxinit;
	ifp->if_ioctl = qxioctl;
	ifp->if_output = qxoutput;
	ifp->if_reset = qxreset;
	if_attach(ifp);
	return(OK);
}

/************************************************************************
*
* qxinit - initialize interface
*
*/

qxinit(unit)
	int unit;
{
	struct qx_softc *qs;
	struct ifnet *ifp;
	struct eth_desc *desc_ptr;
	unsigned char *buf_ptr;
	unsigned int i;

	qs = &qx_softc[unit];
	ifp = &qs->qs_if;

	/* Check for resources already allocated */
	if(ifp->if_flags & IFF_RUNNING)		
		return;

	/* Initialize OpenChip Ethernet descriptor bufs */

	desc_ptr = (struct eth_desc *)(((long)qs->ethdesc + 15) & ~0x0f);
	buf_ptr = (unsigned char *)(((long)qs->ethbuf + 3) & ~3);

	qs->eth_rxptr = desc_ptr;

	for (i = 0; i < NQXRXDESC; i++) {
		desc_ptr->et_dptr = buf_ptr;
		if (i != (NQXRXDESC - 1)) 
			desc_ptr->et_next = 
				(struct eth_desc *)((char *)desc_ptr + 16);
		else 
			desc_ptr->et_next = qs->eth_rxptr;
		desc_ptr->et_flags = 0;
		desc_ptr->et_bufsiz = OPE_BUFSIZE;
		desc_ptr->et_datsiz = 0;
		buf_ptr += OPE_BUFSIZE;
		desc_ptr = (struct eth_desc *)((char *)desc_ptr + 16);
	}
	qs->eth_txptr = desc_ptr;

	for (i = 0; i < NQXTXDESC; i++) {
		desc_ptr->et_dptr = buf_ptr;
		if (i != (NQXTXDESC - 1)) 
			desc_ptr->et_next = 
				(struct eth_desc *)((char *)desc_ptr + 16);
		else 
			desc_ptr->et_next = qs->eth_txptr;
		desc_ptr->et_flags = ET_OWN;
		buf_ptr += OPE_BUFSIZE;
		desc_ptr = (struct eth_desc *)((char *)desc_ptr + 16);
	}
	
	/* Reset the chip and mark the interface as running */
	qxreset(unit);
	ifp->if_flags |= IFF_RUNNING;
	
	/* If there's something to transmit, start it */
	if(ifp->if_snd.ifq_head)
		qxstart(unit);
}


/************************************************************************
*
* qxreset - reset the chip 
*
*/

qxreset(unit)
{
	struct qx_softc *qs;
	int i,s;

	qs = &qx_softc[unit];

	s = splimp();
	OPENCHIP->op_ethrstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;
	OPENCHIP->op_ethtstat = OP_ETH_ACT | OP_ETH_EVNT | OP_ETH_ERR;

	/* Reset chip and make pulse last for at least 10msecs */
	Q_OP_PORT2 = OP2_RES_ETHER;
	for(i=0;i<30;i++);
	Q_OP_PORT2 = OP2_SET_ETHER;

	/* Reset OpenChip Ethernet registers and 8003 registers */
	OPENCHIP->op_ethrstat = OP_ETH_INEA;
	OPENCHIP->op_ethtstat = OP_ETH_INEA;
	OPENCHIP->op_ethrx = qs->eth_rxptr;
	qs->qs_qxdev->sq_txstcm = SQ_TX_SUCCESS | SQ_TX_16_ATMPT | SQ_TX_COLL | 
			   SQ_TX_UNDERFLW;
	qs->qs_qxdev->sq_rxstcm = SQ_RX_RCV_SEL | SQ_RX_GOOD_FRM | 
			SQ_RX_DRIBBLE | SQ_RX_CRC | SQ_RX_OVFL;
	splx(s);
}

/************************************************************************
*
* qxintr - interrupt routine
*
*/

qxintr(unit)
	int unit;
{
	unsigned char tmp;
	struct qx_softc *qs;

	qs = &qx_softc[unit];

	/* If receive interrupt, add qxread routine to netd */
	tmp = OPENCHIP->op_ethrstat;
	OPENCHIP->op_ethrstat = (tmp & (OP_ETH_EVNT | OP_ETH_ERR)) 
				| OP_ETH_INEA;
	if(tmp & OP_ETH_EVNT)
		netToDoAdd(qxread,unit);

	/* If transmit interrupt, add qxstart routine to netd */
	tmp = OPENCHIP->op_ethtstat;
	OPENCHIP->op_ethtstat = (tmp & (OP_ETH_EVNT | OP_ETH_ERR)) 
				| OP_ETH_INEA;
	if(tmp & OP_ETH_EVNT) {
		qs->qs_if.if_opackets++;
		netToDoAdd(qxstart,unit);
	}
	return(OK);
}

/************************************************************************
*
* qxoutput - Ethernet output routine
*
*/

qxoutput(ifp,m0,dst)
	struct ifnet *ifp;
	struct mbuf *m0;
	struct sockaddr *dst;
{
	unsigned char edst[6];
	int usetrailers;
	int off;
	int type;
	int s;
	struct in_addr idst;
	struct mbuf *m;
	struct qx_softc *qs;
	struct ether_header *eh;

	qs = &(qx_softc[ifp->if_unit]);
	m = m0;

	switch(dst->sa_family) {
	case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if(!arpresolve(&qs->qs_ac,m,&idst,edst,&usetrailers))
			return(0);
		type = ETHERTYPE_IP;
		off = ((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;	
		if(usetrailers && off > 0 && (off & 0x1ff) == 0 &&
			m->m_off >= MMINOFF + 2 * sizeof (u_short)) {

			type = ETHERTYPE_TRAIL + (off>>9);	
			m->m_off -= 2 * sizeof(u_short);
			m->m_len += 2 * sizeof(u_short);
			*mtod(m,u_short *) = htons((u_short) ETHERTYPE_IP);
			*(mtod(m,u_short *) + 1) = htons((u_short)m->m_len);

			/*
			 * Packet to be sent as trailer: move 1st packet 
			 * (control info) to end of chain
			 */

			while(m->m_next)
				m = m->m_next;
			m->m_next = m0;
			m = m0->m_next;
			m0->m_next = 0;
			m0 = m;
		}
		break;

	case AF_UNSPEC:
		eh = (struct ether_header *)dst->sa_data;
		bcopy((char *)eh->ether_dhost, (char *)edst, sizeof(edst));
		type = eh->ether_type;
		break;

	default:
		printf("qx%d: can't handle af%d\n",ifp->if_unit,dst->sa_family);
		m_freem(m0);
		return(EAFNOSUPPORT);
		break;
	}

	/* Add local net header. If no space in mbuf, allocate another */
	if(m->m_off > MMAXOFF || 
		MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_HEADER);
		if(m == 0) {
			m_freem(m0);
			return(ENOBUFS);
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof(struct ether_header);
	} else {
		m->m_off -= sizeof(struct ether_header);
		m->m_len += sizeof(struct ether_header);
	}
	eh = mtod(m, struct ether_header *);
	bcopy((char *)edst, (char *)eh->ether_dhost, sizeof(edst));
	bcopy((char *)qs->qs_addr, (char *)eh->ether_shost, sizeof(qs->qs_addr));
	eh->ether_type = htons((u_short)type);

	/* Queue msg on interface and start output */
	s = splimp();
	if(IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return(ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	splx(s);
	qxstart(ifp->if_unit);
	return(OK);
}

/************************************************************************
*
* qxstart - start output
*
*/

qxstart(unit)
	int unit;
{
	unsigned char *bp;
	short len;
	int s;
	struct qx_softc *qs;
	struct eth_desc *txptr;
	struct mbuf *m, *mp;
	struct ether_header *eh;

	qs = &(qx_softc[unit]);
	for(txptr = qs->eth_txptr;txptr->et_flags & ET_OWN;txptr = txptr->et_next) {


			
		/* Check Tx status of last packet sent */
		if(txptr->et_flags & ET_UNDR) 
			qs->qs_if.if_oerrors++;
		if(txptr->et_flags & (ET_TX16 | ET_COLL))
			qs->qs_if.if_collisions++;
		txptr->et_flags = ET_OWN;

		s = splimp();
		IF_DEQUEUE(&qs->qs_if.if_snd,m);
		splx(s);	

		if(m == 0)
			break;
		mp = m;

		/* Copy packet to write buffer */
		for(bp = txptr->et_dptr;mp; mp = mp->m_next) {
			if(mp->m_len == 0)
				continue;	
			bcopy(mtod(mp, unsigned char *), bp, (int)mp->m_len);
			bp += mp->m_len;
		}
		m_freem(m);
		len = max(ETHERMIN + sizeof(struct ether_header),bp-(txptr->et_dptr));
		if((etherOutputHookRtn != NULL) &&
		    (* etherOutputHookRtn) (&qs->qs_if,txptr->et_dptr,len))
			continue;
#ifdef	DEBUG
		if(qxtxdebug) {
		  eh = (struct ether_header *) txptr->et_dptr;
  
		  printf("O  D %x.%x.%x.%x.%x.%x",
		    eh->ether_dhost[0],eh->ether_dhost[1],eh->ether_dhost[2],
		    eh->ether_dhost[3],eh->ether_dhost[4],eh->ether_dhost[5]);
		  printf("  S %x.%x.%x.%x.%x.%x",
		    eh->ether_shost[0],eh->ether_shost[1],eh->ether_shost[2],
		    eh->ether_shost[3],eh->ether_shost[4],eh->ether_shost[5]);
		  printf("  Type %x\n",eh->ether_type);
		}
#endif	DEBUG

		txptr->et_datsiz = len;
		txptr->et_flags = 0;
		OPENCHIP->op_ethtx = txptr;
			
	}
	qs->eth_txptr = txptr;


}

/************************************************************************
*
* qxread - Ethernet read routine
*
*/

qxread(unit)
	int unit;
{
	int	foo;
	char *pData;
	short stat;
	int len, off, resid;
	int s;
	struct eth_desc *rxptr;
	struct qx_softc *qs;
	struct ether_header *eh;
	struct mbuf *m;
	struct ifqueue *inq;

	qs = &qx_softc[unit];

	rxptr=qs->eth_rxptr;
	foo = 0;
	do {
		stat = rxptr->et_flags;
		if ( ! (stat & ET_OWN) )
			continue;
		foo++;
		/* Update packets received */
		qs->qs_if.if_ipackets++;	

		/* Check for errors - if errors release descriptor entry */
		if(stat & (ET_OVFL | ET_OVER | ET_CRC | ET_NOCT | ET_SHRT)) {
			qs->qs_if.if_ierrors++;
			rxptr->et_flags = 0;
			continue;
		}

		len = rxptr->et_bufsiz - rxptr->et_datsiz;
		eh = (struct ether_header *) rxptr->et_dptr;

    		if ((etherInputHookRtn != NULL) &&
	 	    (* etherInputHookRtn) (&qs->qs_if, (char *) eh, len))
			return;	

#ifdef	DEBUG
		if(qxrxdebug) {
		  printf("I  D %x.%x.%x.%x.%x.%x",
		    eh->ether_dhost[0],eh->ether_dhost[1],eh->ether_dhost[2],
		    eh->ether_dhost[3],eh->ether_dhost[4],eh->ether_dhost[5]);
		  printf("  S %x.%x.%x.%x.%x.%x",
		    eh->ether_shost[0],eh->ether_shost[1],eh->ether_shost[2],
		    eh->ether_shost[3],eh->ether_shost[4],eh->ether_shost[5]);
		  printf("  Type %x\n",eh->ether_type);
		}
#endif	DEBUG

		/* 
		 * Deal with trailer protocol: if type is trailer
		 * get true type from 1st 16-bit word past data.
		 * Remember type was trailer by setting off.
		 */

/**/
		pData = ((char *) eh) + (sizeof (struct ether_header));
		if(eh->ether_type >= ETHERTYPE_TRAIL &&
		   eh->ether_type < ETHERTYPE_TRAIL + ETHERTYPE_NTRAILER) {
			off = (eh->ether_type - ETHERTYPE_TRAIL) * 512;
			if(off > ETHERMTU) {
				rxptr->et_flags = 0;
				continue;
			}
			eh->ether_type = ntohs(*(u_short *) (pData + off));
			resid	       = ntohs(*(u_short *) (pData + off + 2));
			if(off + resid > len) {
				rxptr->et_flags = 0;
				continue;
			}
			len = off + resid;
		} else 
			off = 0;	
		if (len == 0) {
			rxptr->et_flags = 0;
			continue;
		}
/**/

		/*
		 * Pull packet off interface. Off is nonzero if packet has
		 * trailing header; qxget will force this header info
		 * to be at the front, but we will still have to drop
		 * the type and length which are at the front of any
		 * trailer data.
		 */

/*** LOOK !!! ***/
/* This line should go after qxget ! */
		rxptr->et_flags = 0;
		m = qxget(pData, len, off, (struct ifnet *) &qs->qs_if);

		if(m == 0)
			continue;
		if (off) {
			m->m_off += 2 * sizeof(u_short);
			m->m_len -= 2 * sizeof(u_short);
		}

/**/
		s = splimp();
		switch(eh->ether_type) {
			case ETHERTYPE_IP:
				netToDoAdd(ipintr, 0);
				inq = &ipintrq;
				if (IF_QFULL(inq)) {
					IF_DROP(inq);
					m_freem(m);
				} else {
					IF_ENQUEUE(inq, m);
				}
				
				break;

			case ETHERTYPE_ARP:
				arpinput(&qs->qs_ac, m);
				break;

			default:
				m_freem(m);
				break;
		}
		splx(s);
/**/
	} while ((rxptr=rxptr->et_next) != qs->eth_rxptr );
	qs->eth_rxptr = rxptr;
	OPENCHIP->op_ethrx = rxptr;
}

/************************************************************************
*
* qxget - Pull data off interface
*
* Len is length of data, with local net header stripped.
* Off is non-zero if a trailer protocol was used, and
* gives the offset of the trailer information.
* We copy the trailer information and then all the normal
* data into mbufs.  
* Prepend a pointer to the interface structure,
* so that protocols can determine where incoming packets arrived.
*/

struct mbuf *qxget(buf0, totlen, off0, ifp)
	char *buf0;
	int totlen, off0;
	struct ifnet *ifp;
{

	struct mbuf *top;
	struct mbuf **mp;
	struct mbuf *m;
	int len, off;
	char *buf;

	buf = buf0;
	off = off0;

	top = 0;
	mp = &top;

	while (totlen > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if (m == 0) {
		    m_freem(top);
		    return (0);
		}

		if (off) {
		    len = totlen - off;
		    buf += off;
		} else
		    len = totlen;

		m->m_off = MMINOFF;
		if (ifp) {
		    /* Leave room for ifp. */
		    m->m_len = MIN(MLEN - sizeof(ifp), len);
		    m->m_off += sizeof(ifp);
		} else 
		    m->m_len = MIN(MLEN, len);

		bcopy (buf, mtod(m, char *), (unsigned)m->m_len);
		buf += m->m_len;

		*mp = m;
		mp = &m->m_next;

		if (off) {
			off += m->m_len;
			if (off == totlen) {
				/* 
				 * Reached end of data; setup to move 
				 * trailer front 
				 */

				buf = buf0;
				off = 0;
				totlen = off0;
			}
		} else
		    totlen -= m->m_len;

		if (ifp) {
			/* Prepend interface pointer to first mbuf. */
			m->m_len += sizeof(ifp);
			m->m_off -= sizeof(ifp);
			*(mtod(m, struct ifnet **)) = ifp;
			ifp = (struct ifnet *)0;
			}
	}

	return (top);
}

/************************************************************************
*
* qxioctl
*
*/

qxioctl(ifp,cmd,data)
	struct ifnet *ifp;
	int cmd;
	char *data;
{
	int s, error;
	struct ifaddr *ifa;

	s = splimp();
	ifa = (struct ifaddr *)data;
	error = 0;

	switch(cmd) {
		case SIOCSIFADDR:
			ifp->if_flags |= IFF_UP;
			qxinit(ifp->if_unit);

			switch(ifa->ifa_addr.sa_family) {
			    case AF_INET:
				((struct arpcom *)ifp)->ac_ipaddr = 
				    IA_SIN(ifa)->sin_addr;		
				arpwhohas((struct arpcom *)ifp,
				    &IA_SIN(ifa)->sin_addr);
				break;
			}

		case SIOCSIFFLAGS:
			qxinit(ifp->if_unit);
			break;

		default:
			error = EINVAL; 
			break;
	}
	splx(s);
	return(error);
}

#ifdef	DEBUG
qxstatus()
{
	char unit;
	struct eth_desc *dptr;
	struct qx_softc *qs;

	unit = 0;
	qs = &qx_softc[unit];

	printf("Ethernet Status\n\n");

	printf("Ethernet address = %x.%x.%x.%x.%x.%x\n",
		qs->qs_addr[0],qs->qs_addr[1],qs->qs_addr[2],
		qs->qs_addr[3],qs->qs_addr[4],qs->qs_addr[5]);
	printf("qs->eth_rxptr=0x%x, OPENCHIP->op_ethrx=0x%x\n", 
		qs->eth_rxptr,OPENCHIP->op_ethrx);
	printf("qs->eth_txptr=0x%x, OPENCHIP->op_ethtx=0x%x\n", 
		qs->eth_txptr,OPENCHIP->op_ethtx);
	printf("OPENCHIP->op_ethrstat=0x%x, OPENCHIP->op_ethtstat=0x%x\n",
		OPENCHIP->op_ethrstat,OPENCHIP->op_ethtstat);

	printf("\nOpenChip Rx descriptors\n"); 
	dptr = qs->eth_rxptr;
	do {
		if(dptr->et_flags & ET_OWN) {
		    printf("addr=0x%x, dptr=0x%x, nxt=0x%x, bsiz=%d, dsiz=%d, flags=0x%x\n",
		    	dptr,dptr->et_dptr,dptr->et_next,
			dptr->et_bufsiz,dptr->et_datsiz,dptr->et_flags);
		    }
		dptr = dptr->et_next;
	} while (dptr != qs->eth_rxptr);

	printf("\nOpenChip Tx descriptors\n"); 
	dptr = qs->eth_txptr;
	do {
		if(dptr->et_flags & ET_OWN) {
		    printf("addr=0x%x, dptr=0x%x, nxt=0x%x, bsiz=%d, dsiz=%d, flags=0x%x\n",
		    	dptr,dptr->et_dptr,dptr->et_next,
			dptr->et_bufsiz,dptr->et_datsiz,dptr->et_flags);
		}
		dptr = dptr->et_next;
	} while (dptr != qs->eth_txptr);
}
#endif	DEBUG

get_ethernum(enaddr)
	char *enaddr;
{
	struct nv_ram nv_ram;

	if (sysGetNvRam(&nv_ram) == ERROR)
		return(ERROR);
	else {
		*enaddr++ = nv_ram.enet_addr[0];
		*enaddr++ = nv_ram.enet_addr[1];
		*enaddr++ = nv_ram.enet_addr[2];
		*enaddr++ = nv_ram.enet_addr[3];
		*enaddr++ = nv_ram.enet_addr[4];
		*enaddr = nv_ram.enet_addr[5];
		return(OK);
	}
}

#ifdef	DEBUG
extern struct arptab arptab[];
qxprintarp()
{

	int i;
	struct in_addr *pip;
	struct arptab *parptab;

	for(i=0; i < (19*9); i++) {
	    parptab = &arptab[i];
		if(parptab->at_flags) {
		    pip = &(parptab->at_iaddr);
		    printf("arptab[%d] ip addr=%d.%d.%d.%d\n",
			i,(pip->s_addr>>24) & 0xff,(pip->s_addr>>16) & 0xff,
			(pip->s_addr>>8) & 0xff,pip->s_addr & 0xff);
		    printf("           et addr=%x.%x.%x.%x.%x.%x\n",
			parptab->at_enaddr[0], parptab->at_enaddr[1],
			parptab->at_enaddr[2], parptab->at_enaddr[3],
			parptab->at_enaddr[4], parptab->at_enaddr[5]);
		}
	}
}
#endif	DEBUG
