%{
/* imtobsd.lex - lexical analyzer for intermetrics to bsd obj module converter*/

/*
modification history
--------------------
01b,20jan88,dnw  changed debugging options
01a,10jul87,dnw  written
*/

/* debugging option macro */

#define dbg(name)	lexlineno = yylineno; \
			if (debugOptions & DBG_LEX) \
			    lexdebug ("name: \"%s\"\n", yytext)

/* table of token strings and values */

typedef struct
    {
    char *tokenString;
    int tokenValue;
    } TOKEN_DEF;

LOCAL TOKEN_DEF tokenTable [] =
    {
    ".abs",   L_T_ABS,
    ".aorg",  L_T_AORG,
    ".bgn",   L_T_BGN,
    ".dcl",   L_T_DCL,
    ".defg",  L_T_GLOBAL,
    ".defl",  L_T_LOCAL,
    ".end",   L_T_END,
    ".ext",   L_T_EXT,
    ".file",  L_T_FILE_STMT,
    ".group", L_T_GROUP,
    ".id",    L_T_ID,
    ".len",   L_T_LENGTH,
    ".line",  L_T_LINE,
    ".mark",  L_T_MARK,
    ".org",   L_T_ORIGIN,
    ".seg",   L_T_SEGMENT,
    ".start", L_T_START,
    NULL, 0,	/* table terminator */
    };

/* forward declaration */

TOKEN_DEF *lexlookup ();
%}

/* lex expressions */

token		\.[a-z]+
identifier	\{[\41-\174\176]*\}
string		\"([^\"\\\n]|\\(.|\n))*\"
expr_tag	:[A-Za-z0-9]
dec_number	-?[0-9]+
hex_digit	[0-9A-Fa-f]
hex_number	\#{hex_digit}+
hex_string	\'{hex_digit}+\'
ID_num		%[0-9]+
white		[ \t]
newline		\n
%%
{token}		{
		TOKEN_DEF *pTokenDef;

		dbg (TOKEN);

		/* look up token in token table */

		if ((pTokenDef = lexlookup (yytext, tokenTable)) != NULL)
		    {
		    yylval.string = pTokenDef->tokenString;
		    return (pTokenDef->tokenValue);
		    }
		else
		    return (L_T_BADCMD);
		}
{identifier}	{
		dbg (IDENTIFIER);
		yylval.string = yytext;
		return (L_IDENT);
		}
{string}	{
		dbg (STRING);
		yylval.string = yytext;
		return (L_STRING);
		}
{expr_tag}	{
		dbg (EXPR_TAG);
		yylval.ch = yytext [1];
		return (L_EXPR_TAG);
		}
{dec_number}	{
		dbg (DEC_NUMBER);
		sscanf (yytext, "%d", &yylval.num);
		return (L_NUMBER);
		}
{hex_number}	{
		dbg (HEX_NUMBER);

		/* you won't believe this but "scanf" is screwed up on the
		 * vax: it won't scan the input "0" as a valid hex number,
		 * so.......... */

		if ((yytext[1] == '0') && (yytext[2] == EOS))
		    yylval.num = 0;
		else
		    sscanf (&yytext[1], "%x", &yylval.num);

		return (L_NUMBER);
		}
{hex_string}	{
		dbg (HEX_STRING);
		yylval.string = yytext;
		return (L_HEX_STRING);
		}
{ID_num}	{
		dbg (ID_NUM);
		sscanf (&yytext[1], "%d", &yylval.num);
		return (L_ID_NUM);
		}
{white}		;
.		{
		dbg (CHAR);
		yylval.ch = yytext[0];
		return (yytext[0]);
		}
\n		{ return (L_EOLN); }
%%


/*******************************************************************
*
* debug - output debug msg
*/

VOID lexdebug (fmt, arg)
    char *fmt;
    int arg;
    {
    fprintf (stderr, fmt, arg);
    }
/*******************************************************************
*
* lexlookup - lookup name in token table
*/

TOKEN_DEF *lexlookup (name, table)
    char *name;		/* name to lookup */
    TOKEN_DEF table [];	/* table in which to look */

    {
    FAST TOKEN_DEF *pToken = table;

    while (pToken->tokenString != NULL)
	{
	if (strcmp (pToken->tokenString, name) == 0)
	    return (pToken);

	++pToken;
	}

    return (NULL);
    }
