/* wind.h - WRS kernel header file */

/*
modification history
--------------------
01c,23aug88,gae  moved assembler offsets here, removed LIST declarations.
01b,18aug88,jcf	 fixed definition of JOB structure.
01a,03mar88,jcf	 written.
*/


#ifndef	INCwindh
#define	INCwindh

#ifndef	ASMLANGUAGE
#include "vwModNum.h"
#include "taskLib.h"
#include "lstLib.h"

/* status codes */

#define S_wind_TASK_ID_ERROR		(M_taskLib | 1)


typedef struct			/* WIND_TCB - task control block */
    {
    /* priNode is a list of tasks sorted in order of priority.   *
     * This field is used by the blocked q, delay q, and ready q */
    NODE priNode;		/*  00: */

    /* tcbNode is a list that links all active processes or all dead *
     * processes together (a process is either dead or alive) */
    NODE tcbNode;		/*  08: */

    UTINY priority;		/*  16: priority 0 = highest, 255 = lowest */
    UTINY mode;			/*  17: process mode byte */
    short status;		/*  18: status of task */
    char *name;			/*  20: process name */
    int valid;			/*  24: verify pid: ~.W <KEY> must = PID */

    int delay;			/*  28: remainder of time to delay, in ticks */
    short tslice;		/*  32: remainder of time slice, in ticks */

    short sr;			/*  34: process status register */
    INSTR *pc;			/*  36: program counter */
    short foroff;		/*  40: format/offset from frame (68020 only) */
    int d0;			/*  42: */
    int d1;			/*  46: */
    int d2;			/*  50: */
    int d3;			/*  54: */
    int d4;			/*  58: */
    int d5;			/*  62: */
    int d6;			/*  66: */
    int d7;			/*  70: */
    int a0;			/*  74: */
    int a1;			/*  78: */
    int a2;			/*  82: */
    int a3;			/*  86: */
    int a4;			/*  90: */
    int a5;			/*  94: */
    int a6;			/*  98: */
    char *ssp;			/* 102: stack ptr */
    TCBX tcbx;			/* 106: historical extension to kernel TCB */
    
    SEM_ID semId;		/* 1xx: the semaphore pending on (if any) */

    /* posible extensions */
    int	userExtension;		/* 1xx: */

    /* spare fields */
    int spare1;			/* 1xx: spares */
    int spare2;			/* 1xx: */
    int spare3;			/* 1xx: */
    int spare4;			/* 1xx: */
    } WIND_TCB;

typedef struct		/* JOB */
    {
    NODE node;		/* used to keep work in a list */
    FUNCPTR function;	/* function to invoke */
    int	arg1;		/* list of arguments to pass */
    int arg2;
    } JOB;

/* task status values for kernel */

#define WIND_READY	0x00	/* ready to run */
#define WIND_SUSPEND	0x01	/* explicitly suspended */
#define WIND_PEND	0x02	/* pending on semaphore */
#define WIND_DELAY	0x04	/* suspended for task delay (or timeout) */
#define WIND_SIG	0x08	/* executing signal routine */
#define WIND_EVENT	0x10	/* executing signal routine */
#define WIND_DEAD	0x20	/* dormant task control block */

#else

/* assembler structure offsets, must be in sync with above */
 
#define         EXC_FRAME1      34      /* exception frame */
#define         EXC_FRAME2      38	/* dummy exception frame */
#define         TCB_SR          34	/* status register */
#define         TCB_PC          36	/* program counter */
#define         TCB_FOR         40	/* format/offset */
#define         TCB_REGS        42      /* register block */
#define         TCB_DREGS       42      /* register block */
#define         TCB_AREGS       74      /* register block */
#define         TCB_SSP         102     /* register block */
#define         TCB_EXT         106     /* tcb extension */

#endif	ASMLANGUAGE

#endif	INCwindh
