/* tyLib.h - tty handler library header */

/*
modification history
--------------------
02j,04may88,jcf  changed SEMAPHORE to SEM_ID.
02i,15jun87,ecs  added canceled to rdState & wrtState of TY_DEV.
02h,24dec86,gae  changed stsLib.h to vwModNum.h.
02g,07apr86,dnw  removed ST_ERROR status and added rdError flag to smpte mode.
02f,23mar86,jlf  changed GENERIC to NOT_GENERIC.
02e,22aug85,dnw	 replaced xState with rdState and wrtState structures.
		 added rdSmpteState and wrtSmpteState to SMPTE only version.
02d,16aug84,dnw  removed S_tyLib_SMPTE_READ_ERROR from GENERIC version.
		 added lnNBytes and lnBytesLeft members to TY_DEV for
		   line-protocol mode.
02c,15aug84,jlf  changed back to tyLib.h
02b,13aug84,ecs  got rid of S_tyLib_UNKNOWN_REQUEST.
		 changed S_tyLib_READ_ERROR to S_tyLib_SMPTE_READ_ERROR.
02a,10aug84,jlf  changed to tyLib.hx - new mega-file format.
01g,08aug84,ecs  added include of stsLib.h, status codes.
01f,15jun84,dnw  changed TY_DEV to work with new i/o system and ring buffer lib.
01e,27jan84,ecs  added inclusion test.
01d,15sep83,dnw  added xon/xoff stuff: xState field in TY_DEV and definitions
		   of states XST_...
01c,29jul83,dnw	 added ST_TX_CR and removed txStopped.
		 diddled with TY_DEV to make it simpler & more consistent.
		 fiddled with device states to put them in order and
		   confuse the innocent.
01b,22jul83,ecs  added options & status, changed expectCk to TBOOL.
01a,24jun83,ecs  written
*/

#ifndef INCtyLibh
#define INCtyLibh	1

#include "iosLib.h"
#include "rngLib.h"
#include "semLib.h"
#include "vwModNum.h"
#include "wdLib.h"


#ifdef NOT_GENERIC

/* tyLib status codes */

#define S_tyLib_SMPTE_READ_ERROR	(M_tyLib | 1)

/* smpte device states */

#define ST_IDLE			0	/* channel not busy */
#define ST_TX			1	/* channel transmitting */
#define ST_GET_COUNT		3	/* waiting 1st char of smpte msg */
#define ST_GET_BIN_COUNT	4	/* waiting 2nd char of cksm smpte msg */
#define ST_GET_MSG		5	/* getting data bytes of smpte msg */
#define ST_GET_CKSUM		6	/* waiting cksum of smpte msg */

#endif


/* HIDDEN */

typedef struct		/* TY_DEV - tty device descriptor */
    {
    DEV_HDR	devHdr;		/* i/o device header */

    RING_ID	rdBuf;		/* ring buffer for read */
    SEM_ID	rdSemId;	/* reader semaphore id */
    struct			/* current state of the read channel */
	{
	unsigned xoff      : 1;	/* input has been XOFF'd */
	unsigned pending   : 1;	/* XON/XOFF will be sent when xmitter is free */
        unsigned semNeeded : 1;	/* int level should post sem when char rcvd */
        unsigned canceled  : 1;	/* read has been canceled */
	}	rdState;

    RING_ID	wrtBuf;		/* ring buffer for write */
    SEM_ID	wrtSemId;	/* writer semaphore id */
    struct			/* current state of the write channel */
	{
	unsigned busy      : 1;	/* transmitter is busy sending character */
	unsigned xoff      : 1;	/* output has been XOFF'd */
	unsigned cr        : 1;	/* CR should be inserted next (after LF) */
	unsigned semNeeded : 1;	/* int level should post sem when char xmited */
        unsigned canceled  : 1;	/* write has been canceled */
	}	wrtState;

    UTINY	lnNBytes;	/* number of bytes in unfinished new line */
    UTINY	lnBytesLeft;	/* number of bytes left in incompletely
				   dequeued line */
    unsigned short options;	/* options in effect for this channel */
    FUNCPTR	txStartup;	/* pointer to routine to start xmitter */
    WDOG_ID	wdog;		/* watchdog node id */

#ifdef NOT_GENERIC
    TINY	rdSmpteState;	/* state of smpte read channel */
    TINY	wrtSmpteState;	/* state of smpte write channel */
    TBOOL	rdError;	/* TRUE = smpte read error */
    short	byteCount;	/* # of bytes expected in incoming smpte msg */
    TINY	keep;		/* used to build chars from smpte 'AA/' form */
    TINY	numdig;		/* # of incoming digit of smpte 'AA/' form */
    TBOOL	expectCk;	/* flag that checksum expected at end of
				   incoming message */
    TINY	cksum;		/* holds our prediction of what checksum char
				   should be */
#endif

    } TY_DEV;

/* END_HIDDEN */

typedef TY_DEV *TY_DEV_ID;

#endif
