/* rtULib.h - header for RT-11 file I/O library for UNIX */

/*
modification history
--------------------
01d,06jun88,dnw  changed name from rtLib to rtLib.
01c,29may85,jlf  removed secsPerTrack and bytesPerSec, which are now in
		 the RT_VOL_DESC.  Changed function declarations from
		 rtU{Rd,Wrt}Blk to rtU{Rd,Wrt}Sec.
01b,01aug84,dnw  added secsPerTrack and bytesPerSec to RT_UNIX_DEV
01a,11jun84,dnw  written
*/

#ifndef INCrtULibh
#define INCrtULibh	1

#include "rtLib.h"

typedef struct	/* RT_UNIX_DEV - device descriptor for rt-11 under UNIX */
    {
    RT_VOL_DESC rtvol;	/* rt-11 volume descriptor */
    int fd;		/* UNIX fd for this device */
    } RT_UNIX_DEV;


/* function declarations */

STATUS rtURdSec ();
STATUS rtUWrtSec ();

#endif
