/* icmp_var.h - internet control message protocol variable header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)icmp_var.h	7.1 (Berkeley) 6/5/86
 */

/*
modification history
--------------------
02c,23jun88,rdc  made hist arrays in icmpstat be ICMP_MAXTYPE elements.
02b,04nov87,dnw  moved declaration of icmpstat structure to ip_icmp.c.
02a,03apr87,ecs  added header and copyright.
*/

#ifndef INCicmp_varh
#define INCicmp_varh

/*
 * Variables related to this implementation
 * of the internet control message protocol.
 */
struct	icmpstat
    {
    /* statistics related to icmp packets generated */

    int	icps_error;		/* # of calls to icmp_error */
    int	icps_oldshort;		/* no error 'cuz old ip too short */
    int	icps_oldicmp;		/* no error 'cuz old was icmp */
    int	icps_outhist[ICMP_MAXTYPE + 1];

    /* statistics related to input messages processed */

    int	icps_badcode;		/* icmp_code out of range */
    int	icps_tooshort;		/* packet < ICMP_MINLEN */
    int	icps_checksum;		/* bad checksum */
    int	icps_badlen;		/* calculated bound mismatch */
    int	icps_reflect;		/* number of responses */
    int	icps_inhist[ICMP_MAXTYPE + 1];
    };

#endif
