/* domain.h - domain header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)domain.h	7.1 (Berkeley) 6/4/86
 */

/*
modification history
--------------------
02b,04nov87,dnw  moved declaration of domains structure to uipc_dom.c.
02a,03apr87,ecs  added header and copyright.
*/

#ifndef INCdomainh
#define INCdomainh

/* Structure per communications domain. */

struct	domain
    {
    int		dom_family;		/* AF_xxx */
    char	*dom_name;
    int		(*dom_init)();		/* initialize domain data structures */
    int		(*dom_externalize)();	/* externalize access rights */
    int		(*dom_dispose)();	/* dispose of internalized rights */
    struct	protosw *dom_protosw;
    struct	protosw *dom_protoswNPROTOSW;
    struct	domain *dom_next;
    };

#endif
