/* operations for all tape drives */
/* NOTE!! The order of numbering is important */

#define MTWEOF	0	/* write an end-of-file record */
#define MTFSF	1	/* forward space file */
#define MTBSF	2	/* backward space file */
#define MTFSR	3	/* forward space record */
#define MTBSR	4	/* backward space record */
#define MTREW	5	/* rewind */
#define MTOFFL	6	/* rewind and put the drive offline */
#define MTNOP	7	/* no operation, sets status only */
#define MTRET	8	/* ISI: retension the tape */
#define MTRST	9	/* ISI: reset operation */
#define MTERASE	10	/* ISI: erase the entire tape */
#define MTEXCLUDE 12	/* set exclusive access to single task */
#define	MTNOREWIND 13	/* set/clear no-rewind-on-close */
#define	MTSWAPBYTE 14	/* set/clear no-rewind-on-close */

/* operations for SCSI drives */

#define GTISI	33	/* ISI: set/clear ISI header */
#define GTPREVENT 34	/* prevent/allow tape removal */
#define GTSETBKSZ 36	/* set block size */

/* structure for MTIOCGET - mag tape get status command */

struct	mtget	{
/* the following two registers are grossly device dependent */
	short	mt_dsreg;	/* ``drive status'' register */
	short	mt_erreg;	/* ``error'' register */
/* end device-dependent registers */
	short	mt_resid;	/* residual count */
/* the following two are not yet implemented */
	daddr_t	mt_fileno;	/* file number of current position */
	daddr_t	mt_blkno;	/* block number of current position */
/* end not yet implemented */
};

/* structure for MTIOCTOP - mag tape operation command */

struct mtop	{
	short 	mt_op;		/* operation */
	daddr_t	mt_count;	/* count */
};

#define MTIOCTOP	1
#define MTIOCGET	2
#define MTIOCIEOT	3
#define MTIOCEEOT	4
