/* lstLib.h - doubly linked list library header */

/*
modification history
--------------------
01d,21may86,llk	 added forward declaration of lstNStep.
01c,03jun84,dnw  changed list.{head,tail} to list.node.
		 added declarations of lst{First,Last,Next,Previous}.
01b,27jan84,ecs  added inclusion test.
01b,15mar83,dnw  changed name from lstlb to lstLib
*/

#ifndef INClstLibh
#define INClstLibh	1


/* type definitions */

typedef struct node		/* Node of a linked list. */
    {
    struct node *next;		/* Points at the next node in the list */
    struct node *previous;	/* Points at the previous node in the list */
    } NODE;


/* HIDDEN */

typedef struct			/* Header for a linked list. */
    {
    NODE node;			/* Header list node */
    int count;			/* Number of nodes in list */
    } LIST;

/* END_HIDDEN */


/* function declarations */

NODE *lstFirst ();
NODE *lstGet ();
NODE *lstLast ();
NODE *lstNext ();
NODE *lstNth ();
NODE *lstPrevious ();
NODE *lstNStep ();

#endif
