/* iosLib.h - I/O system header file */

/*
modification history
--------------------
01j,30jun88,llk  added definition of iosNextDevGet().
01i,04jun88,llk  removed S_iosLib_INVALID_DEVICE_NAME.
01h,12apr88,gae  moved defn's of FD_ENTRY & DRV_ENTRY to iosLib.c.
01g,16dec87,jlf  changed de_dummy field in DRV_ENTRY to de_inuse.
01f,30sep87,gae  added name field to FD_ENTRY.
01e,29apr87,dnw  added S_iosLib_CONTROLLER_NOT_PRESENT.
01d,24dec86,gae  changed stsLib.h to vwModNum.h.
01c,01dec86,dnw  changed DEV_HDR.name to be ptr to name instead array of name.
01b,07aug84,ecs  added status codes and include of stsLib.h
01a,08jun84,dnw  written
*/

#ifndef INCiosLibh
#define INCiosLibh

#include "ioLib.h"
#include "lstLib.h"
#include "vwModNum.h"

/* status codes */

#define S_iosLib_DEVICE_NOT_FOUND		(M_iosLib | 1)
#define S_iosLib_DRIVER_GLUT			(M_iosLib | 2)
#define S_iosLib_INVALID_FILE_DESCRIPTOR	(M_iosLib | 3)
#define S_iosLib_TOO_MANY_OPEN_FILES		(M_iosLib | 4)
#define S_iosLib_CONTROLLER_NOT_PRESENT		(M_iosLib | 5)
#define S_iosLib_DUPLICATE_DEVICE_NAME		(M_iosLib | 6)

typedef struct		/* DEV_HDR - device header for all device structures */
    {
    NODE node;			/* device linked list node */
    short drvNum;		/* driver number for this device */
    char *name;			/* device name */
    } DEV_HDR;


/* function declarations */

IMPORT DEV_HDR *iosDevFind ();
IMPORT DEV_HDR *iosNextDevGet ();

#endif INCiosLibh
