/* dsmLib.h - header for disassembler library */

/*
modification history
--------------------
01j,26oct87,hin  added fpp instructions.
01i,14sep87,llk  change itShift to itRegShift.  Added itMemShift.
01h,05dec86,gae  changed stsLib.h to vwModNum.h.
01g,03apr86,llk	 added 68020 instructions, INSTTWO [] structure, 
		 more control registers.
01f,12jun85,rdc  added 68010 instructions.
01e,08nov84,jlf  added itExt
01d,21sep84,jlf  added itCmpm
01c,17sep84,jlf  added itAdda
01b,16aug84,jlf  added itDb and itScc.
01a,07aug84,ecs  peeled from dsmLib.c
*/

#ifndef INCdsmLibh
#define INCdsmLibh	1

#include "vwModNum.h"


/* dsmLib status codes */

#define S_dsmLib_UNKNOWN_INSTRUCTION	(M_dsmLib | 1)


/* instruction types */

#define	itBra		0
#define	itChk		1
#define	itComplete	2
#define	itDynBit	3
#define	itExg		4
#define	itImm		5
#define	itMoveB		6
#define	itMovep		7
#define	itMovem		8
#define	itMoveq		9
#define	itNbcd		10
#define	itNegx		11
#define	itOr		12
#define	itQuick		13
#define	itBcd		14
#define	itRegShift	15
#define	itStop		16
#define	itSwap		17
#define	itTrap		18
#define	itX		19
#define	itMoveW		20
#define	itMoveL		21
#define	itMoveFSR	22
#define	itMoveTSR	23
#define	itMoveCCR	24
#define	itMoveUSP	25
#define itStatBit	26
#define itLea		27
#define itLink		28
#define itUnlk		29
#define itDb		30
#define itScc		31
#define itAdda		32
#define itCmpm		33
#define itExt		34
#define itRTD		35
#define itMoves		36
#define itMoveFCCR	37
#define itMovec		38
#define itChk2		39
#define itBfchg		40
#define itBfext		41
#define itBfins		42
#define itCallm		43
#define itLinkL		44
#define itBkpt		45
#define itTrapcc	46
#define itPack		47
#define itTwoWord	48
#define itImmCCR	49
#define itImmTSR	50
#define itCas		51
#define itCas2		52
#define itRtm		53
#define itDivW		54
#define itDivL		55
#define itMoveA		56
#define itCpBcc		57
#define itCpDbcc	58
#define itCpTrapcc	59
#define itCpGen		60
#define itCpScc		61
#define itCpSave	62
#define itMemShift	63

/* fpp instructions */
#define itFpp		99
#define itFb		100
#define itFrestore	101
#define itFsave		102
#define itFabs		103
#define itFacos		104
#define itFadd		105
#define itFasin		106
#define itFatan		107
#define itFatanh	108
#define itFcmp		109
#define itFcos		110
#define itFcosh		111
#define itFdb		112
#define itFdiv		113
#define itFetox		114
#define itFetoxm1	115
#define itFgetexp	116
#define itFgetman	117
#define itFint		118
#define itFintrz	119
#define itFlog10	120
#define itFlog2		121
#define itFlogn		122
#define itFlognp1	123
#define itFmod		124
#define itFmove		125
#define itFmovek	126
#define itFmovel	127
#define itFmovecr	128
#define itFmovem	129
#define itFmovemc	130
#define itFmul		131
#define itFneg		132
#define itFnop		133
#define itFrem		134
#define itFscale	135
#define itFs		136
#define itFsgldiv	137
#define itFsglmul	138
#define itFsin		139
#define itFsincos	140
#define itFsinh		141
#define itFsqrt		142
#define itFsub		143
#define itFtan		144
#define itFtanh		145
#define itFtentox	146
#define itFtrap		147
#define itFtst		148
#define itFtwotox	149

typedef struct
    {
    char *name;
    unsigned short op;
    unsigned short mask;
    int type;
    } INST;

typedef struct
    {
    unsigned short op;
    unsigned short mask;
    INST inst;
    } INSTTWO;

/* Control registers */

#define SFC	0x000	/* Source Function Code register */
#define DFC	0x001	/* Destination Function Code register */
#define CACR	0x002	/* Cache Control Register */
#define USP	0x800	/* User Stack Pointer */
#define VBR	0x801	/* Vector Base Register */
#define CAAR	0x802	/* Cache Address Register */
#define MSP	0x803	/* Master Stack Pointer */
#define ISP	0x804	/* Interrupt Stack Pointer */

#endif
