
/* ANSI STANDARD  GENERIC SCSI DEFINITIONS */

union	scsi_cdb {		/* SCSI command block */
    struct    cdb_0 {		    /* COMMAND GROUP 0 */
/* 0*/	UTINY	cdb_0_cmd;		/* command code */
#define		  CMD_TESTREADY	0x00	/*   test unit ready */
#define		  CMD_REZERO	0x01	/*   rezero unit */
#define		  CMD_SENSE	0x03	/*   request sense */
#define		  CMD_FORMAT	0x04	/*   format unit */
#define		  CMD_BLKLIM	0x05	/*   read block limits */
#define		  CMD_REASSIGN	0x07	/*   re-assign blocks */
#define		  CMD_READ 	0x08	/*   read data */
#define		  CMD_WRITE	0x0A	/*   write data */
#define		  CMD_SEEK 	0x0B	/*   seek */
#define		  CMD_FILEMARK 	0x10	/*   write file mark */
#define		  CMD_SPACE 	0x11	/*   space */
#define		  CMD_INQUIRY	0x12	/*   inquiry */
#define		  CMD_MSELECT	0x15	/*   mode select */
#define		  CMD_RESERVE	0x16	/*   reserve */
#define		  CMD_RELEASE	0x17	/*   release */
#define		  CMD_ERASE	0x19	/*   erase tape */
#define		  CMD_S_DIAG	0x1C	/*   send diagnostic */
#define		  CMD_R_DIAG	0x1D	/*   receive diagnostic rslt */
#define		  CMD_MSENSE	0x1A	/*   mode sense */
#define		  CMD_STARTSTOP	0x1B	/*   start/stop unit */
#define		  CMD_PREVENT	0x1E	/*   prevent medium release */
#define		  CMD_LOADCART	0xCF	/*   load/unload cartridge */
/* 1*/	UTINY	cdb_0_lun	: 3;	/* logical unit number */
	UTINY	cdb_0_lba_h	: 5;	/* high part of address */
/* 2*/	UTINY	cdb_0_lba_m;		/* middle part of address */
/* 3*/	UTINY	cdb_0_lba_l;		/* low part of address */
/* 4*/	UTINY	cdb_0_len;		/* block count */
/* 5*/	UTINY			: 6;	/* reserved */
	UTINY  cdb_0_fr	: 1;	/* flag request */
	UTINY  cdb_0_link	: 1;	/* link */
    }		cdb_0;
#define	SET_CDB_0(cdb, cmd, lun, lba, len, fr, link)		{	\
		bzero(cdb, sizeof (struct cdb_0));			\
		(cdb)->cdb_0.cdb_0_cmd = cmd;				\
		(cdb)->cdb_0.cdb_0_lun = lun;				\
		SCSI_HML_SET((cdb)->cdb_0.cdb_0_lba, lba);		\
		(cdb)->cdb_0.cdb_0_len = len;				\
		(cdb)->cdb_0.cdb_0_fr = fr;				\
		(cdb)->cdb_0.cdb_0_link = link;			}
    struct    cdb_1 {		    /* COMMAND GROUP 1 */
/* 0*/	UTINY	cdb_1_cmd;		/* command code */
#define		  CMD_RCAPAC	0x25	/*   read capacity */
#define		  CMD_XREAD	0x28	/*   extended read data */
#define		  CMD_XWRITE	0x2A	/*   extended write data */
#define		  CMD_XSEEK	0x2B	/*   extended seek */
#define		  CMD_VERIFY	0x2F	/*   verify data */
/* 1*/	UTINY	cdb_1_lun	: 3;	/* logical unit number */
	UTINY			: 4;	/* reserved */
	UTINY	cdb_1_reladr	: 1;	/* relative address */
/* 2*/	UINT	cdb_1_lba;		/* (4 bytes) logical block address */
/* 6*/	UTINY			: 8;	/* reserved */
/* 7*/	UTINY	cdb_1_len_h;		/* length (high) */
/* 8*/	UTINY	cdb_1_len_l;		/* length (low) */
/* 9*/	UTINY			: 6;	/* reserved */
	UTINY  cdb_1_fr	: 1;	/* flag request */
	UTINY  cdb_1_link	: 1;	/* link */
    }		cdb_1;
#define	SET_CDB_1(cdb, cmd, lun, reladr, lba, len, fr, link)	{	\
		bzero(cdb, sizeof (struct cdb_1));			\
		(cdb)->cdb_1.cdb_1_cmd = cmd;				\
		(cdb)->cdb_1.cdb_1_lun = lun;				\
		(cdb)->cdb_1.cdb_1_reladr = reladr;			\
		(cdb)->cdb_1.cdb_1_lba = lba;				\
		SCSI_HL_SET((cdb)->cdb_1.cdb_1_len, len);		\
		(cdb)->cdb_1.cdb_1_fr = fr;				\
		(cdb)->cdb_1.cdb_1_link = link;			}
    struct    cdb_7 {		    /* COMMAND GROUP 7 */
/* 0*/	UTINY	cdb_7_cmd;		/* command code */
#define		CMD_RESET	0xF0	/*   ISI reset device or ctlr */
#define		CMD_INIT 	0xF1	/*   ISI reinit controller */
#define		CMD_STATUS	0xF2	/*   ISI return status */
#define		CMD_VERSION	0xF3	/*   ISI return firmware vers */
#define		CMD_DUMPREG	0xF4	/*   ISI dump reg states */
/* 1*/	UTINY			: 6;	/* reserved */
	UTINY  cdb_7_fr	: 1;	/* flag request */
	UTINY  cdb_7_link	: 1;	/* link */
    };
    UTINY	cdb_raw[16];		/* pad to 16 bytes for gsreg.h */
};

/* defines for scsi completion status byte */
#define	SCSI_STATUS_PARITY	0x01
#define	SCSI_STATUS_CHECK	0x02
#define	SCSI_STATUS_CM		0x04
#define	SCSI_STATUS_BUSY	0x08
#define	SCSI_STATUS_INTER	0x10
#define	SCSI_STATUS_BITS	"\20\5INTER\4BUSY\3CM\2CHECK\1PARITY"

union	scsi_sns {		/* data returned by CMD_SENSE */
	struct sns_06 {		/* non-extended sense data format */
	    UTINY sns_06_lbav	: 1;	/* logical block is valid */
	    UTINY sns_06_class	: 3;	/* error class (0-6) */
	    UTINY sns_06_code	: 4;	/* error code */
	    UTINY sns_06_lba_h;	/* high logical block address */
	    UTINY sns_06_lba_m;	/* middle logical block address */
	    UTINY sns_06_lba_l;	/* low logical block address */
	}	sns_06;
	struct sns_7 {		/* extended sense data format */
/* 0*/	    UTINY sns_7_valid	: 1;	/* sense data is valid */
	    UTINY sns_7_class	: 3;	/* error class (7) */
	    UTINY 		: 4;	/* not used */
/* 1*/	    UTINY sns_7_seg_num;	/* segment number */
/* 2*/	    UTINY sns_7_fil_mk	: 1;	/* file mark on device */
	    UTINY sns_7_eom	: 1;	/* end of media */
	    UTINY sns_7_ili	: 1;	/* incorrect length indicator */
	    UTINY	 	: 1;	/* reserved */
	    UTINY sns_7_key	: 4;	/* sense key */
#define		SNS_7_KEY_NO_SENSE	0x0
#define		SNS_7_KEY_RECOVERED	0x1
#define		SNS_7_KEY_NOT_READY	0x2
#define		SNS_7_KEY_MEDIUM_ERROR	0x3
#define		SNS_7_KEY_HW_ERROR	0x4
#define		SNS_7_KEY_ILL_REQUEST	0x5
#define		SNS_7_KEY_UNIT_ATTN	0x6
#define		SNS_7_KEY_DATA_PROTECT	0x7
#define		SNS_7_KEY_BLANK_CHECK	0x8
#define		SNS_7_KEY_VU		0x9
#define		SNS_7_KEY_COPY_ABORTED	0xa
#define		SNS_7_KEY_ABORT_CMD	0xb
#define		SNS_7_KEY_EQUAL		0xc
#define		SNS_7_KEY_VOL_OVERFLOW	0xd
#define		SNS_7_KEY_MISCOMPARE	0xe
#define		SNS_7_KEY_RESERVED	0xf
/* 3*/	    UTINY sns_7_info_h;	/* information */
/* 4*/	    UTINY sns_7_info_mh;	/* information */
/* 5*/	    UTINY sns_7_info_ml;	/* information */
/* 6*/	    UTINY sns_7_info_l;	/* information */
/* 7*/	    UTINY sns_7_add_len;	/* number of additional bytes */
/* 8*/	    UTINY sns_7_xxx[4];	/* reserverd for copy search cmd */
/*12*/	    UTINY sns_7_err;		/* extended sense error codes */
#define		SNS_7_ERR_
	}	sns_7;
};

struct	scsi_inq {		/* data returned by CMD_INQUIRY */
/* 0*/	UTINY	inq_pdtype;		/* Peripheral Device Type */
#define		  INQ_PDT_DISK	0x00	/*   Direct-access device */
#define		  INQ_PDT_TAPE	0x01	/*   Sequential-access device */
#define		  INQ_PDT_PRINT	0x02	/*   Printer device */
#define		  INQ_PDT_PROC	0x03	/*   Processor device */
#define		  INQ_PDT_WORM	0x04	/*   Write-once read-multiple device */
#define		  INQ_PDT_RO	0x04	/*   Read only device */
#define		  INQ_PDT_NOLUN	0x7f	/*   Logical unit not present */
/* 1*/	UTINY	inq_removable	: 1;	/* removable */
	UTINY	inq_dtypeq	: 7;	/* device type qualifier */
/* 2*/	UTINY	inq_isov	: 2;	/* ISO version */
	UTINY	inq_emcav	: 3;	/* EMCA version */
	UTINY	inq_ansiiv	: 3;	/* ANSII version */
/* 3*/	UTINY	inq_rdf;		/* response data format */
/* 4*/	UTINY	inq_addlen;		/* additional length */
/* 5*/	UTINY	inq_vu[3];		/* pad vender unique data */
/* 8*/	UTINY	inq_vendor[8];		/* vendor name ASCII */
/*16*/	UTINY	inq_product[16];	/* vendor product name ASCII */
/*32*/	UTINY	inq_rev[4];		/* vendor product revision ASCII */
};

struct	blk_desc {		/* block descriptor: CMD_MSENSE, CMD_MSELECT */
	UTINY	bd_density;	/*   block descriptor density */
	UTINY	bd_nb_h;	/*   high number of blocks */
	UTINY	bd_nb_m;	/*   mid number of blocks */
	UTINY	bd_nb_l;	/*   low number of blocks */
	UTINY		: 8;	/*   reserved */
	UTINY	bd_bl_h;	/*   high block length */
	UTINY	bd_bl_m;	/*   mid block length */
	UTINY	bd_bl_l;	/*   low block length */
};

struct	pag_desc {		/* page descriptor: CMD_MSENSE, CMD_MSELECT */
    UTINY	pd_save		: 1;	/*   parameter savable */
    UTINY			: 1;	/*   reserved */
    UTINY	pd_code		: 6;	/*   page code */
#define		  PD_ERROR	0x01	/*	Error Recovery Parameters */
#define		  PD_DISRE	0x02	/*	Disconnect Reconnect Params */
#define		  PD_FORMAT	0x03	/*	Format Parameters Parameters */
#define		  PD_GEOMETRY	0x04	/*	Drive Geometry Parameters */
#define		  PD_ALL	0x3F	/*	All Pages */
    UTINY	pd_len;			/*   page length */
    union	pd_pg {
	struct pg_err {			/*   ERROR PAGE */
	    UTINY	err_awre	: 1;	/* auto write reallocation */
	    UTINY	err_arre	: 1;	/* auto read reallocation */
	    UTINY	err_tb		: 1;	/* transfer block on error */
	    UTINY	err_rc		: 1;	/* read continuous */
	    UTINY	err_ecc		: 1;	/* enable early correction */
	    UTINY	err_per		: 1;	/* post errors (report soft)*/  
	    UTINY	err_dte		: 1;	/* disable transfer on error */
	    UTINY	err_dcr		: 1;	/* disable correction */
	    UTINY	err_retries;		/* retry count */
	    UTINY	err_cspan;		/* correction span */
	    UTINY	err_hoffset;		/* head offset */
	    UTINY	err_dsoffset;		/* data strobe offset */
	    UTINY	err_tlimit;		/* recovery time limit */
	}	pg_err;
	struct pg_dis {			/*   DISCONNECT RECONNECT PAGE */
	    UTINY	dis_bfulr;		/* buffer full ratio */
	    UTINY	dis_beulr;		/* buffer empty ratio */
	    USHORT	dis_bil;		/* bus inactivity limit */
	    USHORT	dis_distime;		/* disconnect time limit */
	    USHORT	dis_retime;		/* reconnect time limit */
	    USHORT	dis_xxx;		/* reserved */
	}	pg_dis;
	struct pg_fmt {			/*   FORMAT PAGE */
	    USHORT	fmt_tpz;		/* tracks/zone */
	    USHORT	fmt_alt_spz;		/* alternate sectors/zone */
	    USHORT	fmt_alt_tpz;		/* alternate tracks/zone */
	    USHORT	fmt_alt_tpv;		/* alternate tracks/volume */
	    USHORT	fmt_spt;		/* sectors/track */
	    UTINY	fmt_bps;		/* bytes/sector */
	    UTINY	fmt_interleave;		/* interleave factor */
	    UTINY	fmt_t_skew;		/* track skew factor */
	    UTINY	fmt_c_skew;		/* cylinder skew factor */
	    UTINY	fmt_ssec	: 1;	/* soft sector formatting */
	    UTINY	fmt_hsec	: 1;	/* hard sector formatting */
	    UTINY	fmt_rmb		: 1;	/* removable */
	    UTINY	fmt_surf	: 1;	/* surface lba allocation */
	    UTINY	fmt_ins		: 1;	/* inhibit save */
	    UTINY			: 3;
	}	pg_fmt;
	struct	pd_geo {		/*   GEOMETRY PAGE */
	    UTINY	geo_cyl_h;		/* number of cylinders */
	    UTINY	geo_cyl_m;
	    UTINY	geo_cyl_l;
	    UTINY	geo_heads;		/* number of heads */
	    UTINY	geo_cyl_wp_h;		/* start write precomp cyl */
	    UTINY	geo_cyl_wp_m;
	    UTINY	geo_cyl_wp_l;
	    UTINY	geo_cyl_rw_h;		/* start reduced write cyl */
	    UTINY	geo_cyl_rw_m;
	    UTINY	geo_cyl_rw_l;
	    USHORT	geo_step_rate;		/* step rate */
	    UTINY	geo_cyl_ld_h;		/* landing zone cylinder */
	    UTINY	geo_cyl_ld_m;
	    UTINY	geo_cyl_ld_l;
	    UTINY	geo_rsvd[3];
	}	pg_geo;
    }	pd_pg;
};

struct	scsi_msen {		/* data returned by CMD_MSENSE */
	UTINY	msen_len;		/* sense data length */
	UTINY	msen_mtype;		/* medium type */
	UTINY	msen_wprot	: 1;	/* write protected if 1 */
	UTINY	msen_rsvd	: 7;	/* reserved */
	UTINY	msen_bdl;		/* block descriptor length */
	struct	blk_desc msen_bd;	/* block descriptor */
	struct	pag_desc msen_pd;	/* page descriptor */
};

struct	scsi_msel {		/* data returned by CMD_MSELECT */
	UTINY			: 8;	/* reserved */
	UTINY	msel_mtype;		/* medium type */
	UTINY			: 8;	/* reserved */
	UTINY	msel_bdl;		/* block descriptor length */
	struct	blk_desc msel_bd;	/* block descriptor */
	struct	pag_desc msel_pd;	/* page descriptor */
};

struct	scsi_rcap {		/* data returned by CMD_RCAPAC */
	UINT	rcap_lba;		/* logical block address */
	UINT	rcap_bl;		/* block length */
};

struct	scsi_blklim {		/* data returned by CMD_BLKLIM */
	ULONG	blklim_max;
	USHORT	blklim_min;
};

/* pick up (set) 2 byte "_h _l" field in (from) an int */
#define	SCSI_HL(x)		((x/**/_h<<8)|(x/**/_l))
#define	SCSI_HL_SET(x, v)	{ x/**/_h=v>>8; x/**/_l=v;}

/* pick up (set) 3 byte "_h _m _l" field in (from) an int */
#define	SCSI_HML(x)		((x/**/_h<<16)|(x/**/_m<<8)|(x/**/_l))
#define	SCSI_HML_SET(x, v)	{ x/**/_h=v>>16; x/**/_m=v>>8; x/**/_l=v;}

/* pick up (set) 4 byte "_h _mh _ml _l" field in (from) an int */
#define	SCSI_HMML(x)		\
		    ((x/**/_h<<24)|(x/**/_mh<<16)|(x/**/_ml<<8)|(x/**/_l))
#define	SCSI_HMML_SET(x, v)	\
		    { x/**/_h=v>>24; x/**/_mh=v>>16; x/**/_ml=v>>8; x/**/_l=v;}

#ifdef	ASCII_SNS_7_KEY
char	*ascii_sns_7_key[] = {
		"NO SENSE", "RECOVERED", "NOT READY", "MEDIUM ERROR",
		"HARDWARE ERROR", "ILLEGAL REQUEST", "UNIT ATTENTION",
		"DATA PROTECT", "BLANK CHECK", "VENDOR UNIQUE", "COPY ABORTED",
		"ABORT COMMAND", "EQUAL", "VOLUME OVERFLOW", "MISCOMPARE",
		"RESERVED",
};
#endif	ASCII_SNS_7_KEY
#ifdef	ASCII_PDTYPE
char	*ascii_pdtype[] = {
		"DISK", "TAPE", "PRINTER", "PROCESSOR", "WORM"
};
#endif	ASCII_PDTYPE


/* Single byte messages */

#define	MSG_CMD_COMPLETE	0x00	/* Command Complete */
#define	MSG_EXTENDED		0x01	/* Extended Message */
#define	MSG_SAVE_DPTR		0x02	/* Save Data Pointer */
#define	MSG_RESTORE_PTRS	0x03	/* Restore Pointers */
#define	MSG_DISCONNECT		0x04	/* Disconnect Message */
#define	MSG_INIT_DET_ERR	0x05	/* Initiator Detected Error */
#define	MSG_ABORT		0x06	/* Abort */
#define	MSG_MSG_REJECT		0x07	/* Message Reject */
#define	MSG_NOOP		0x08	/* No Operation */
#define	MSG_PAR_ERR		0x09	/* Message Parity Error */
#define	MSG_LNK_CMD_COMP	0x0a	/* Linked Command Complete */
#define	MSG_LNK_CMD_COMP_FLG 	0x0b	/* Linked Command Complete With Flag */
#define	MSG_BUS_DEV_RESET	0x0c	/* Bus Device Reset */

#define	MSG_IDENTIFY		0x80 	/* Identify Message */
#define	ID_DIS_REC		0x40	/* Initiator can accomodate dis/rec */

