/*
 * VMEBUS: Integrated Solutions VME-GP-SCSI controller interface defines
 */

struct	gsdevice	{	/* HOST ADAPTOR CONTROL REGISTERS */
	USHORT	gs_loc;
#define		GS_LOC_ID	0x7200	/*   read value of gs_loc */
#define		GS_LOC_ID_MASK	0xFF00	/*   host adaptor id mask */
#define		GS_LOC_HID_MASK	0x0007	/*   host adaptor scsi id mask */
#define		GS_LOC_INIT	0xF100	/*   start initialize sequence */
#define		GS_LOC_INIT_FLG	0x00	/*   special init parameters */
#define		GS_LOC_INIT_OK	(~GS_LOC_INIT & 0xFFFF) /*   done init seq */
#define		GS_LOC_GO	0x0000	/*   tell controller to look at hacb */
};

struct	gs_hacb	{		/* HOST ADAPTOR CONTROL BLOCK */
    USHORT	hacb_dcr;		/* device control register */
#define		DCR_GO		0x0100	/*	shift by target */
#define		DCR_BUSY	0x0001	/*	shift by target */
    USHORT	hacb_semhost;		/* Semaphore registers */
    USHORT	hacb_semhadpt;
    USHORT	hacb_pad;		/* reserved ... */
    struct	hacb_dcb {		/* DEVICE CONTROL BLOCK */
/* 0*/	UTINY		dcb_err		: 1;	/* composite error */
	UTINY		dcb_cerr	: 7;	/* controller error code */
#define		DCB_CERR_OK	0		/*   no controller errors */
#define		DCB_CERR_CMDERR	2		/*   host sent a bad command */
#define		DCB_CERR_SELERR	3		/*   error selecting target */
#define		DCB_CERR_IERR	4		/*   wrong interrupt occured */
#define		DCB_CERR_TMOERR	5		/*   host adaptor timeout */
#define		DCB_CERR_PCERR	6		/*   SPC in wrong phase */
#define		DCB_CERR_VMERR	7		/*   vme address casued berr */
#define		DCB_CERR_PARITY	8		/*   SPC parity error */
#define		DCB_CERR_RECERR	9		/*   unexpected reconnect */
/* 1*/	UTINY		dcb_scsi_status;	/* scsi completion status */
/* 2*/	UTINY		dcb_ie		: 1;	/* interrupt enable */
#define		DCB_NOIE	0		/*   disable interrupts */
#define		DCB_IE		1		/*   enable interrupts */
	UTINY		dcb_dir		: 1;	/* data direction ? */
#define		DCB_DIR_IN	0		/*   data dir is to host */
#define		DCB_DIR_OUT	1		/*   data dir is to target */
#define		DCB_DIR_NO	0		/*   no data to transfer */
	UTINY		dcb_sw		: 1;	/* swap bytes ? */
#define		DCB_NOSW	0		/*   don't byte swap on data */
#define		DCB_SW		1		/*   byte swap on data */
	UTINY		dcb_nodisc	: 1;	/* disconnect/reconnect ? */
#define		DCB_DISC	0		/*   disconnect/reconnect */
#define		DCB_NODISC	1		/*   no disconnect/reconnect */
	UTINY				: 4;
/* 3*/	UTINY		dcb_cdblen;		/* scsi_cdb length */
/* 4*/	UTINY		dcb_bw		: 2;	/* HOSTBUS data width */
#define		DCB_BW_8	0
#define		DCB_BW_16	1
#define		DCB_BW_32	2
	UTINY		dcb_am		: 6;	/* HOSTBUS address modifier */
#define		DCB_AM_STD_S_D	0x3D		/*   Std Supervisior Data */
/* 5*/	UTINY		dcb_iv;			/* interrupt vector */
/* 6*/	UTINY		*dcb_dadr;		/* data start address */
/*10*/	UINT		dcb_dlen;		/* amount of data */
/*14*/	USHORT		dcb_dbsz;		/* data block size */
/*16*/	union scsi_cdb	dcb_cdb;		/* command descriptor block */
    }	hacb_dcb[8];
#define	SET_DCB(dcb, ie, dir, sw, disc, cdblen, bw, am, iv, dadr, dlen, dbsz) {\
		(dcb)->dcb_err = 0;					\
		(dcb)->dcb_cerr = 0;					\
		(dcb)->dcb_scsi_status = 0;				\
									\
		(dcb)->dcb_ie = ie;					\
		(dcb)->dcb_dir = dir;					\
		(dcb)->dcb_sw = sw;					\
		(dcb)->dcb_nodisc = disc;				\
		(dcb)->dcb_cdblen = cdblen;				\
		(dcb)->dcb_bw = bw;					\
		(dcb)->dcb_am = am;					\
		(dcb)->dcb_iv = iv;					\
		(dcb)->dcb_dadr = (UTINY *) dadr;			\
		(dcb)->dcb_dlen = dlen;					\
		(dcb)->dcb_dbsz = dbsz;					}
};

#ifdef	KERNEL
struct hacb_dcb	*gsgetdcb();
#endif	KERNEL

#ifdef	ASCII_DCB_CERR
char	*ascii_dcb_cerr[] = {
	" ", "HOST COMMAND ERROR", "ERROR SELECTING TARGET",
	"SELECT TIMEOUT", "WRONG INTERRUPT", "HOST ADAPTOR TIMEOUT",
	"SPC IN WRONG PHASE", "VME BUS ERROR", "STATUS NOT RECVD",
	"UNEXPECTED RECONNECT", "DIRECTION ERROR", "UNEXPECTED DISCONNECT",
	"HUNG: BUS RESET", "KILLED BY RESET", 
	"0xE", "0xF", "0x10",
};
#endif	ASCII_DCB_CERR
