/* UniWorks.h - UniWorks standard definitions header */

/*
modification history
--------------------
01s,22jun88,dnw	 moved READ, WRITE, and UPDATE back here from ioLib.h.
01r,22apr88,gae  oops! forgot some #endif's in 01q.
01q,12apr88,gae  removed QUICK & WAIT; added STD_{IN,OUT,ERR}.
		 fixed #define's of FALSE, TRUE, etc.
		 moved READ, WRITE, and UPDATE to ioLib.h.
01p,04dec87,dnw  added undefine of MC68000 to get around Green Hills bug that
		   pre-defines MC68000.
01o,12nov87,ecs  added type ULONG.
01n,08feb86,dnw  added types INSTR, UINT, USHORT.
01m,14oct85,rdc  added BUS types.
01l,16jul85,jlf  added conditional for NULL and EOF.
01k,24jun85,rdc  installed condtional compile so we can include in
		 assembly language files.  See instructions below.
		 Added System type macro and CPU type macro.
01j,13jun85,dnw  cleaned-up, removed more obsolete stuff to wrs.h
01i,11sep84,jlf  changed name from wrs.h to UniWorks.h.  removed GLOBAL.
01h,03jun84,dnw  removed IGNORE declaration.
01g,09apr84,jlf  added MEMBER_SIZE macro.
01f,14dec83,dnw  added MSB, LSB macros
01e,17nov83,jlf  added STATUS type, for routines which return a status.
01d,13jul83,dnw  added NELEMENTS macro
01c,14May83,dnw  added OFFSET macro
01b,17Feb83,dnw  added stuff from Whitesmiths std.h
01a,15Feb83,dnw  written
*/


#if	!defined(NULL) || (NULL!=0)
#define NULL		0
#endif

#if	!defined(EOF) || (EOF!=(-1))
#define EOF		(-1)
#endif

#if	!defined(FALSE) || (FALSE!=0)
#define FALSE		0
#endif

#if	!defined(TRUE) || (TRUE!=1)
#define TRUE		1
#endif


#define NONE		(-1)	/* for times when NULL won't do */
#define EOS		'\0'	/* C string terminator */


/* return status values */

#define OK		0
#define ERROR		(-1)

/* low-level I/O input, output, error fd's */

#define	STD_IN	0
#define	STD_OUT	1
#define	STD_ERR	2

/* modes - must match O_RDONLY/O_WRONLY/O_RDWR in ioLib.h! */

#define READ		0
#define WRITE		1
#define UPDATE		2

/* SYSTEM types */

#define V7		1	/* ATT version 7 */
#define SYS_V		2	/* ATT System 5 */
#define BSD_4_2		3	/* Berkeley BSD 4.2 */

/* CPU types */

/* The Green Hills compiler pre-defines "MC68000"!! */
#ifdef	is68k
#undef	MC68000
#endif	is68k

#define MC68000		1
#define MC68010		2
#define MC68020		3
#define MC68030		4

/* BUS types */

#define VME_BUS		1
#define MULTI_BUS	2

/* Interprocessor communication types */

#define USE_IPI		1
#define USE_POLL	2
#define USE_BOTH	3


/* macros */

#define MSB(x)	(((x) >> 8) & 0xff)	/* most signif byte of 2-byte integer */
#define LSB(x)	((x) & 0xff)		/* least signif byte of 2-byte integer*/

#define OFFSET(structure, member)	/* byte offset of member in structure*/\
		((int) &(((structure *) 0) -> member))

#define MEMBER_SIZE(structure, member)	/* size of a member of a structure */\
		(sizeof (((structure *) 0) -> member))

#define NELEMENTS(array)		/* number of elements in an array */ \
		(sizeof (array) / sizeof ((array) [0]))

#define FOREVER	for (;;)

#define max(x, y)	(((x) < (y)) ? (y) : (x))
#define min(x, y)	(((x) < (y)) ? (x) : (y))


/* type definitions */

#define FAST	register
#define IMPORT	extern
#define LOCAL	static

/* The following stuff must NOT be included if this include file is used
 * from assembly language.  Just #define ASMLANGUAGE before the include,
 * to get rid of it. */

#ifndef ASMLANGUAGE

typedef int (*FUNCPTR) ();		/* pointer to a function */

typedef char TINY;
typedef char TBOOL;
typedef unsigned char UTINY;
typedef unsigned short USHORT;
typedef unsigned int UINT;
typedef unsigned long ULONG;
typedef int ARGINT, BOOL, VOID, STATUS;
typedef unsigned short INSTR;		/* word-alligned instructions */

#endif ASMLANGUAGE
