#ifndef INCconfigh
#define INCconfigh

#include "vme68k30.h"
#include "vme.h"
#include "iv68k.h"

#define BUS	VME_BUS
#define	CPU	MC68030

#define	TARGET_ISI
#define TARGET_TYPE_IS68K30

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/is30/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of VxWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
/*#define INCLUDE_FORTRAN*/
/*#define INCLUDE_PASCAL		/* support for Pascal */
#define	INCLUDE_1.5COMPAT	/* 1.5 compatibility routines */

/* included hardware support */

#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DR		/* IKON DR11-W controller */

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_IE		/* include Sun Ethernet interface*/
#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_BP		/* include backplane net interface */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - vxWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100


/* Device controller I/O addresses: standard */

#ifndef VME_SHORTIO
#define	VME_SHORTIO	0x80000000
#define VME_STANDARD	0x88000000	/* 16 bit transfers */
#define	VME_EXTENDED	0x90000000
#define VME_STANDARD_32 0x98000000 	/* 32 bit transfers */
#endif VME_SHORTIO

#define VME_WINDOW_STD	0
#define	VME_WINDOW_EXT	0

/* interrupt vectors */

#define INT_VEC_CONSOLE		IVEC_TO_INUM (IV_AUTOVEC_4)
#define INT_VEC_CLOCK		IVEC_TO_INUM (IV_AUTOVEC_6)
#define INT_VEC_NMI		IVEC_TO_INUM (IV_AUTOVEC_7)
#define INT_VEC_IPI		(108)

/*
* Mailbox interrupt addresses:
* processor #:       vme short i/o address:
*     0                   0xF000
*     1                   0xF200
*     2                   0xF400
*     3                   0xF600
*     4			  0xF800
*     5			  0xFA00
*     6			  0xFC00
*     7			  0xFE00
*/

/* The ISI VME-68k30 can also be used with ISI vb driver */

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */

/* memory addresses */

/*
 * Local-to-Bus memory address constants
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* fixed */


/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0xF0000000


#endif	INCconfigh
