/* vme68k20.h - Integrated Solutions VME-68k20 CPU board header file */

/*
modification history
--------------------
01f,29apr88,gae  added BUS and CPU constants.
01e,17nov87,dnw	 definitions of int vectors to config.h.
01d,20oct86,jlf  added constants for usart timer.
01c,05mar86,llk	 written.
	   +rdc
*/

/*
This file contains I/O address and related constants for
UniWorks on the Integrated Solutions VME-68k20.
*/

#ifndef	INCvme68k20h
#define	INCvme68k20h

#define	TARGET_ISI_VME68K20
#define TARGET_ISI

#define BUS	VME_BUS
#define	CPU	MC68020


/* port addresses for Signetics SCN2681 DUART */

#define N_USART_CHANNELS	2		/* Number of serial channels */

#define	VME_U_BASE	0x58000000

#define	VME_U_MR2A ((char *) (VME_U_BASE+0x00))  /* Mode Registers A1 and A2 */
#define	VME_U_MR1A ((char *) (VME_U_BASE+0x00))  /* Mode Registers A1 and A2 */
#define	VME_U_MR2B ((char *) (VME_U_BASE+0x10))  /* Mode Registers B1 and B2 */
#define	VME_U_MR1B ((char *) (VME_U_BASE+0x10))  /* Mode Registers B1 and B2 */
#define VME_U_IMR  ((char *) (VME_U_BASE+0x0A))  /* Interrupt Mask Register */
#define VME_U_ISR  ((char *) (VME_U_BASE+0x0A))  /* Interrupt Status Register */
#define VME_U_CRA  ((char *) (VME_U_BASE+0x04))  /* Command Register A */
#define VME_U_CRB  ((char *) (VME_U_BASE+0x14))  /* Command Register B */
#define VME_U_CSRA ((char *) (VME_U_BASE+0x02))  /* Clock Select Register A */
#define VME_U_CSRB ((char *) (VME_U_BASE+0x12))  /* Clock Select Register B */
#define VME_U_RHRA ((char *) (VME_U_BASE+0x06))  /* Rx Holding Register A */
#define VME_U_THRA ((char *) (VME_U_BASE+0x06))  /* Tx Holding Register A */
#define VME_U_RHRB ((char *) (VME_U_BASE+0x16))  /* Rx Holding Register B */
#define VME_U_THRB ((char *) (VME_U_BASE+0x16))  /* Tx Holding Register B */
#define VME_U_ACR  ((char *) (VME_U_BASE+0x08))  /* Aux Control Reg */
#define VME_U_CTUR ((char *) (VME_U_BASE+0x0C))  /* Counter/Timer MSB */
#define VME_U_CTLR ((char *) (VME_U_BASE+0x0E))  /* Counter/Timer LSB */
#define VME_U_START_TMR ((char *) (VME_U_BASE+0x1C)) /* start-timer command */
#define VME_U_STOP_TMR ((char *) (VME_U_BASE+0x1E))  /* stop-timer command */


/* Bit values for options selected by MR1A/B of the DUART */

#define	VME_U_NO_PAR	0x10
#define	VME_U_8_BITS	0x03


/* Bit values for options selected by MR2A/B of the DUART */

#define	VME_U_1_STOP	0x07


/* Bit values for options selected by CRA/B of the DUART */

#define	VME_U_MR_RST	0x08
#define	VME_U_RX_RST	0x10
#define	VME_U_TX_RST	0x18
#define	VME_U_ERR_RST	0x20
#define	VME_U_BRK_RST	0x28	
#define	VME_U_TX_EN	0x04
#define	VME_U_TX_DIS	0x08
#define	VME_U_RX_EN	0x01
#define	VME_U_RX_DIS	0x02


/* Bit values for options selected by CSRA/B of the DUART */

#define	VME_U_RX_9600	0xB0
#define	VME_U_TX_9600	0x0B
#define	VME_U_RX_1200	0x60
#define	VME_U_TX_1200	0x06


/* Bit values for options selected by IMR of the DUART */

#define	VME_U_INT_RXA		0x02
#define	VME_U_INT_TXA		0x01
#define	VME_U_INT_RXB		0x20
#define	VME_U_INT_TXB		0x10
#define	VME_U_INT_TIMER		0x08

/* memory management stuff */

#define VME_PAGE_SIZE		0x1000

#define VME_TBUF_BASE_SYS	0x30000000
#define VME_TBUF_BASE_USR	0x40000000
#define VME_TBUF_INCR		0x00001000
#define VME_TBUF_INVALID	0x00000000
#define VME_NTBUFS		512		/* for each mode */


/* context register */

#define VME_CTX			((char *) 0x50000000)
#define	VME_CTX_PARITY		0x08		/* 1 => enable parity */
#define	VME_CTX_CLOCK		0x10		/* 1 => enable 60Hz clock */
#define	VME_CTX_LEV2		0x20
#define	VME_CTX_LEV1		0x40
#define	VME_CTX_LED		0x80		/* 1 => turn OFF led */
#define VME_CTX_CNODE		0x0f


#define VME_PTP_BASE		0x60000000
#define VME_PTP_INCR		0x00200000
#define	VME_PTP_LSB		0x00100000
#define VME_PTP_INVALID		0x00000780
#define VME_NPTPS		128		/* for each context */

#define VME_TBBE_VALID		0x80000000	/* valid bit for tbbe */

/* bits and commands in the DUART ACR reg */

#define VME_U_ACR_BRG_SEL	0x80		/* select BRG freq */
#define VME_U_ACR_CTR_EXT	0x00		/* counter-mode, extern clock */
#define VME_U_ACR_CTR_TXCA	0x10		/* counter-mode, Tx clock A */
#define VME_U_ACR_CTR_TXCB	0x20		/* counter-mode, Tx clock B */
#define VME_U_ACR_CTR_XTAL	0x30		/* counter-mode, xtal */
#define VME_U_ACR_TMR_EXT	0x40		/* timer-mode, extern clock */
#define VME_U_ACR_TMR_EXT_16	0x50		/* timer-mode, extern / 16 */
#define VME_U_ACR_TMR_XTAL	0x60		/* timer-mode, xtal */
#define VME_U_ACR_TMR_XTAL_16	0x70		/* timer-mode, xtal / 16 */

#endif	INCvme68k20h
