#ifndef INCconfigh
#define INCconfigh

#include "vme68k20.h"
#include "vme.h"
#include "iv68k.h"

#define	TARGET_ISI
#define TARGET_TYPE_IS68K20

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/is20/UniWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
/*#define INCLUDE_FORTRAN*/
/*#define	INCLUDE_PASCAL		/* support for Pascal */
#define	INCLUDE_1.5COMPAT	/* 1.5 compatibility routines */

/* included hardware support */

#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DR		/* Ikon 10084/10089 DR-11 controller */

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_IE			/* include Sun Ethernet interface*/
#define INCLUDE_ENP		/* include CMC Ethernet interface*/
#define INCLUDE_BP		/* include backplane net interface */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100


/* Device controller I/O addresses: standard */

#define	VME_SHORTIO	0x00FD0000
#define VME_STANDARD	0x00000000
#define	VME_EXTENDED	0x00000000
#define VME_WINDOW_STD	0
#define	VME_WINDOW_EXT	0

/* interrupt vectors */

#define INT_VEC_CONSOLE		IVEC_TO_INUM (IV_AUTOVEC_5)
#define INT_VEC_CLOCK		IVEC_TO_INUM (IV_AUTOVEC_6)

#define INT_VEC_BP	IVEC_TO_INUM (IV_AUTOVEC_4)	/* backplane int */


/* backplane network parameters */

/*
 * Mailbox interrupt addresses:
 * processor #:       VME short I/O address:
 *     0                   0xc000
 *     1                   0xc002
 *     2                   0xc004
 *     3                   0xc006
 */

#define BP_ANCHOR_ADRS	((char *) (0x800000))		/* bp anchor adrs */

#define BP_INT_TYPE	BP_INT_MAILBOX_2		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO		/* bus address space */
#define BP_INT_ARG2	(0xC000 | (sysProcNum << 1))	/* bus adrs */
#define BP_INT_ARG3	0				/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS		/* bp shared mem adrs */
#define BP_MEM_SIZE	0x80000			/* 512k */


/* The ISI VME-68k20 can also be used with ISI vb driver */

#define VB_SHARED_MEM	0x00f00000		/* vb backplane shared memory */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the VME-68k20 local memory always appears at 0 locally and
 * at 0 on the bus when dual ported.
 */

#define LOCAL_MEM_LOCAL_ADRS	0		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0		/* fixed */


/* The following address is the base address of the on-board rom. */

#define ROM_BASE_ADRS           0x54000000


#endif	INCconfigh
