#include "globram.h"
#include "io.h"
#include "state.h"



unsigned long hex(),hex2(),hex4(),hex6(),hex8();
unsigned long gethex(),gethex2(),gethex4(),gethex6(),gethex8();
#define CTL(x)	(x & 0x1f)

char banner[] = "68030 Boot Prom %s\n";
char *helpmesg[] = {
	"qu restart\n",
	"tm transparent mode\n",
	"lo load S-records\n",
	"he list of commands\n",
	"mm memory modify\n",
	"md memory display\n",
	"rm register modify\n",
	"rd register display\n",
	"bp break point set\n",
	"bc break point clear\n",
	"bd break point display\n",
	"tr trace program\n",
	"fr floppy read\n",
	"fw floppy write\n",
	"ff floppy format\n",
	"ir ide read\n",
	"iw ide write\n",
	"bo boot from floppy,ide\n",
	"go start executing\n",
	"ct switch context\n",
	"os return to OS\n",
	(char *)0
};

struct globram xxx, *globram = &xxx;
static int cold = 1;
int printer=0;
extern char vers[];

main()
{
char buf[256];
int  (*fn)();
int x;


	globram->console = CONSOLE;
	if(cold){
		cold = 0;

		if(init(globram->console) < 0 && globram->console ==  CONSOLE){
			globram->console = 1;
			init(globram->console);
		}
		if(globram->console != 0)
			modemctl(globram->console,M_DTR|M_RTS,0xff);

		printf(banner,vers);
		printf("Console on ");
		if(globram->console == 0) printf("VGA/KBD\n");
		else printf("COM%d\n",globram->console);

		debug_init();

		printf("Strike a Key to abort boot sequence\n");

		x = 200000;
		while(x){
			if(instat(globram->console))
				break;
			x--;
		}
		if(!x){
			buf[0] = 0;
			buf[1] = 0;
			buf[2] = 0;
			boot(buf);
		}
	}else{
		trap();
		buf[0] = 'r';
		buf[1] = 'd';
		buf[2] = '\0';
		rdisplay(buf);
	}
	

	while(1){
		printf("\n%d>",getctxt());
		gets(buf);
		if(buf[0] == '\0')
			continue;
		else if(buf[0] == 't' && buf[1] == 'm')
			trans(buf);
		else if(buf[0] == 'l' && buf[1] == 'o')
			load(buf);
		else if(buf[0] == 'g' && buf[1] == 'o')
			runat(buf);
		else if(buf[0] == 'b' && buf[1] == 'o')
			boot(buf);
		else if(buf[0] == 'h' && buf[1] == 'e')
			help(buf);
		else if(buf[0] == 'm' && buf[1] == 'm')
			mmodify(buf);
		else if(buf[0] == 'm' && buf[1] == 'd')
			mdisplay(buf);
		else if(buf[0] == 'f' && buf[1] == 'r')
			fread(buf);
		else if(buf[0] == 'f' && buf[1] == 'w')
			fwrite(buf);
		else if(buf[0] == 'i' && buf[1] == 'r')
			iread(buf);
		else if(buf[0] == 'i' && buf[1] == 'w')
			iwrite(buf);
		else if(buf[0] == 'f' && buf[1] == 'f')
			fformat(buf);
		else if(buf[0] == 'r' && buf[1] == 'd')
			rdisplay(buf);
		else if(buf[0] == 'r' && buf[1] == 'm')
			rmodify(buf);
		else if(buf[0] == 'b' && buf[1] == 'p')
			bset(buf);
		else if(buf[0] == 'b' && buf[1] == 'd')
			bdisplay(buf);
		else if(buf[0] == 'b' && buf[1] == 'c')
			bclear(buf);
		else if(buf[0] == 't' && buf[1] == 'r')
			trace(buf);
		else if(buf[0] == 'o' && buf[1] == 's')
			runos(buf);
		else if(buf[0] == 'c' && buf[1] == 't')
			swctxt(buf);
		else if(buf[0] == 'p' && buf[1] == 'r'){
			prt_init();
			printer = printer?0:1;
			printf("Printer %s \n",printer?"on":"off");
		}else if(buf[0] == 'q' && buf[1] == 'u'){
			fn = (int (*)())0;
			fn();
		}else
			puts("???");
	}
}
help(buf)
char *buf;
{
char **cpp;

	printf(banner,vers);

	cpp = helpmesg;
	while(*cpp)
		puts(*cpp++);
}
trans(buf)
char *buf;
{
register char c;
register int port ;
	buf+=2;
	if(*buf == '\0') port = 2;
	else port = hex(&buf);
	init(port);
	putchar('\n');
	modemctl(port,M_RTS|M_DTR,0);
	while(1){
		if(c = instat(globram->console)){
			if(c == 0x01) break;
			outchar(port,c);
		}
		if(c = instat(port)){
			outchar(globram->console,c);
		}
	}
	putchar('\n');
}
load(buf)
char *buf;
{
register int port ;
register char c;
char *cp,typ;
register unsigned char dat,sum;
register unsigned long addr,len;
int i = 0;

	buf+=2;
	if(*buf == '\0') port = 2;
	else port = hex(&buf);

	putchar('\n');
	puthex2(port);
	putchar('\n');

	init(port);
	modemctl(port,M_DTR|M_RTS,0);

	while(1){
top:
		modemctl(port,M_RTS,0);
		while(1){
			c = instat(port);
			if((port == globram->console && c == 0x01) ||
				(instat(globram->console) == 0x01))
				goto out;
			if(c == 'S' || c == 's')
				break;
		}
		cp = buf;
		while(1){
			while(!(c = instat(port)))
				;
			if(c == '\r' || c == '\n')
				break;
			*cp++ = c;
		}
		*cp = '\0';

/*
		inline(port,buf);
*/

		modemctl(port,0,M_RTS);

		cp = buf;
		typ = *cp++;
		len = hex2(&cp);
		sum = len;
		if(len < 3)
			goto top;
		switch(typ){
			case '1':
			case '9':
				len -= 3;
				addr = hex4(&cp);
				break;
			case '2':
			case '8':
				len -= 4;
				addr = hex6(&cp);
				break;
			case '3':
			case '7':
				len -= 5;
				addr = hex8(&cp); 
				break;
			default:
				goto top;
		}
		sum += (addr >> 24) & 0xff;
		sum += (addr >> 16) & 0xff;
		sum += (addr >> 8) & 0xff;
		sum += addr & 0xff;
		while(len--){
			dat = hex2(&cp);
			sum += dat;
			*(unsigned char *)addr = dat;
			if(*(unsigned char *)addr != dat){
				putchar('M');
				goto top;
			}
			addr++;
		}
		if( hex2(&cp) != (0xff - sum)){
			putchar('C');
			goto top;
		}
		if(typ == '7' || typ == '8' || typ == '9'){
			goto out;
		}
		printf("%c\r","|/-\\"[i++%4]);
	}
out:
	modemctl(port,M_RTS,0);
	return;
}
mdisplay(buf)
char *buf;
{
unsigned char *addr;
int i;
	buf+=2;
	if(*buf)
		globram->addr = hexv(&buf);
	addr = (unsigned char *)globram->addr;

	puthex8(addr);
	for(i=0;i<16;i++){
		putchar(' ');
		puthex2(addr[i]);
	}
	putchar('\n');
	globram->addr = (unsigned long)addr + 16;
}
mmodify(buf)
char *buf;
{
char *cp;
unsigned char *addr;
int i;
	cp = buf+2;
	if(*cp)
		globram->addr = hexv(&cp);
	addr = (unsigned char *)globram->addr;

	/* loop here ... */
	while(1){
		puthex8(addr);
		putchar(' ');
		puthex2(*addr);
		putchar(' ');
		gets(buf);
		putchar('\n');
		cp = buf;
		switch(*cp){
			case '^': addr--; break;
			case '\0': addr++; break;
			case '=': break;
			case '.': goto out;
			default:
				if(*cp >= '0' && *cp <= '9'
					|| *cp >= 'A' && *cp <= 'F'
					|| *cp >= 'a' && *cp <= 'f' )
					*addr = hexv(&cp);
				break;
		}
	}
out:
	globram->addr = (unsigned long)addr;
}
boot(buf)
char *buf;
{
int dev;
int (*addr)() = (int (*)())0x80008000;
unsigned char *lbuf;
int r,n;
unsigned blk=0;

	buf+=2;
	dev = -1;
	if(*buf)
		dev = hexv(&buf);
	else
		dev = 1;


	printf("dev = %x\n",dev);

	lbuf = (unsigned char *)addr;
	blk = 0;
	n = 1;

	while(n){
		switch(dev){
			case 0:
				if(blk == 0){
					floppy_init(0);
					floppy_recalibrate(0);
				}
				r = floppy_read(0,blk,lbuf,n*512);
				if(r<0) goto error;
				break;
			case 1:
				if(blk == 0)
					ide_init(0);
				r = ide_rw(0,0,blk,lbuf,n*512);
				if(r<0) goto error;
				break;
			default:
				puts("no boot device specified\n");
				goto error;
				break;
				
		}
		if(blk == 0){
			/*
				boot block format
				0	bra		| bra to code 
				4	blk		| next block
				8	len		| # of blocks to read
			*/
			blk = ((unsigned long *)lbuf)[1];
			n = ((unsigned long *)lbuf)[2];
			puts("starting block at "); puthex8(blk); putchar('\n');
			puts("# of blocks "); puthex8(n); putchar('\n');
		}else{
			putchar('.');
			n -= r / 512;
			blk += r / 512;
		}
		lbuf += r;
	}
	puts("\nStart at ");
	puthex8(addr);
	putchar('\n');

	if(dev == 0)
		floppy_stop(0);

	startos(addr,0);
	return;
	
error:
	if(dev == 0)
		floppy_stop(0);

	printf("Boot error\n");
	return(-1);
}

fread(buf)
char *buf;
{
int n,r;
int block;
unsigned char *addr; 

	buf+=2;
	if(*buf)
		n = hexv(&buf);
	else
		n = 1;


	addr = (unsigned char *)0x80008000;
	block = 0;
	puthex8(addr); putchar('\n');

	floppy_init(0);
	floppy_recalibrate(0);

	while(n){
		r = (n>9)?9:n;
		floppy_read(0,block,addr,r*512);
		block += r;
		addr += r*512;
		n -= r;
		putchar('.');
	}

	floppy_stop(0);
	putchar('\n');
}
fwrite(buf)
char *buf;
{
int n,r;
int block;
unsigned char *addr; 

	buf+=2;
	if(*buf)
		n = hexv(&buf);
	else
		n = 1;


	addr = (unsigned char *)0x80008000;
	block = 0;
	puthex8(addr); putchar('\n');

	floppy_init(0);
	floppy_recalibrate(0);

	while(n){
		r = (n>9)?9:n;
		floppy_write(0,block,addr,r*512);
		block += r;
		addr += r*512;
		n -= r;
		putchar('.');
	}

	floppy_stop(0);
	putchar('\n');
}
fformat(buf)
char *buf;
{
int block;

	printf("Type return when ready:\n");
	getchar();

	floppy_init(0);
	floppy_recalibrate(0);
	for(block=0;block<1440;block+=9){
		floppy_format(0,block);
		putchar('.');
	}
	putchar('\n');
}
iread(buf)
char *buf;
{
int n,r;
int block;
unsigned char *addr; 

	buf+=2;
	if(*buf)
		n = hexv(&buf);
	else
		n = 1;


	addr = (unsigned char *)0x80008000;
	block = 0;
	puthex8(addr); putchar('\n');

	ide_init(0);

	while(n){
		r = (n>1)?1:n;
		ide_rw(0,0,block,addr,r*512);
		block += r;
		addr += r*512;
		n -= r;
		putchar('.');
	}

	putchar('\n');
}
iwrite(buf)
char *buf;
{
int n,r;
int block;
unsigned char *addr; 

	buf+=2;
	if(*buf)
		n = hexv(&buf);
	else
		n = 1;


	addr = (unsigned char *)0x80008000;
	block = 0;
	puthex8(addr); putchar('\n');

	ide_init(0);

	while(n){
		r = (n>1)?1:n;
		ide_rw(0,1,block,addr,r*512);
		block += r;
		addr += r*512;
		n -= r;
		putchar('.');
	}

	putchar('\n');
}
