/*
	debugging support
	- when monitor is running, it is in 'monitor' state
	- when user code is run via cont, the user context is the
	  current state.
	- register set/modify and breapoint/trace control apply to

	exception	next state
	reset		monitor
	trap 0-14	monitor
	interrupt	monitor
	illegal inst.	monitor
	trace		user
	trap 15		monitor -> user
*/
#include "state.h"

#define NCTX	2
struct state *state, code[NCTX],mon;
int curctx;
int user=0;

struct rnm {
	char *nm;	/* name */
	char off;	/* offset */
	char siz;	/* size */
} rnm[] = {
	{"d0",0,4},
	{"d1",4,4},
	{"d2",8,4},
	{"d3",12,4},
	{"d4",16,4},
	{"d5",20,4},
	{"d6",24,4},
	{"d7",28,4},
	{"a0",32,4},
	{"a1",36,4},
	{"a2",40,4},
	{"a3",44,4},
	{"a4",48,4},
	{"a5",52,4},
	{"a6",56,4},
	{"usp",60,4},
	{"ssp",64,4},
	{"msp",68,4},
	{"pc",72,4},
	{"sr",76,2},
	{"dfc",78,1},
	{"sfc",79,1},
	{"vbr",80,4},
	{"cacr",84,4},
	{"caar",88,4},
	{"crp",92,8},
	{"srp",100,8},
	{"tc",108,4},
	{"tt0",112,4},
	{"tt1",116,4},
	{"mmusr",120,4},
	{(char *)0,0,0}
};

debug_init()
{
char *xx ;
int i,j;
extern char scb[],end[];

	for(j=0;j<NCTX;j++){
		xx = (char *)&code[j];
		for(i=0;i<sizeof(struct state);i++)
			*xx++ = 0;
		code[j].vbr = (unsigned long )scb;
		code[j].sr = 0x2700;
	}
	curctx = 0;
	state = &mon;
}
unsigned long sreg(nm,data)
char *nm;
unsigned long data;
{
char *xx = (char *)&code[curctx];
int offset;
int i;
	i = reg(nm);
	switch(rnm[i].siz){
		case 1:
			return(*(unsigned char*)(xx+rnm[i].off) = data);
		case 2:
			return(*(unsigned short*)(xx+rnm[i].off) = data);
		case 4:
			return(*(unsigned long*)(xx+rnm[i].off) = data);
		default:
			return(-1);
	}
}

unsigned long greg(nm)
char *nm;
{
char *xx = (char *)&code[curctx];
int offset;
int i;
	i = reg(nm);
	switch(rnm[i].siz){
		case 1:
			return(*(unsigned char*)(xx+rnm[i].off));
		case 2:
			return(*(unsigned short*)(xx+rnm[i].off));
		case 4:
			return(*(unsigned long*)(xx+rnm[i].off));
		default:
			return(-1);
	}
}

reg(nm)
char *nm;
{
register int i;
	for(i=0;rnm[i].nm;i++)
		if(match(nm,rnm[i].nm))
			return(i);
	return(0);
}

match(a,b)
register char *a,*b;
{
	while(*a && *b && *a == *b){
		a++;
		b++;
	}
	if(*a == *b)
		return(1);
	return(0);
}

rdisplay(buf)
char *buf;
{
int i;
int ext=0;
	buf += 2;
	if(*buf == 'x')
		ext = 1;

	printf(" d0: ");
	for(i=0;i<8;i++){
                puthex8(code[curctx].reg[i]);
		putchar(' ');
	}
	printf("\n a0: ");
	for(i=0;i<8;i++){
                puthex8(code[curctx].reg[8+i]);
		if(i == 7 && !(code[curctx].sr & 0x2000))
			putchar('*');
		else
			putchar(' ');
	}
	printf("\n");
	printf(" pc: "); puthex8(greg("pc"));
	printf(" sr: "); puthex4(greg("sr"));
	printf(" ssp: "); puthex8(greg("ssp"));
	if((code[curctx].sr & 0x3000) == 0x2000)
		putchar('*');

	printf(" vbr: "); puthex8(greg("vbr"));
	printf(" dfc: "); puthex2(code[curctx].dfc);
	printf(" sfc: "); puthex2(code[curctx].sfc);
	putchar('\n');

	if(ext){
		printf("mmusr: "); puthex2(code[curctx].mmusr);
		printf(" tc: "); puthex8(code[curctx].tc);
		printf(" tt0: "); puthex8(code[curctx].tt0);
		printf(" tt1: "); puthex8(code[curctx].tt1);
		putchar('\n');

		printf(" srp: "); puthex8(code[curctx].srp[0]); puthex8(code[curctx].srp[1]);
		printf(" crp: "); puthex8(code[curctx].crp[0]); puthex8(code[curctx].crp[1]);
		putchar('\n');

		printf("cacr: "); puthex8(code[curctx].cacr);
		printf(" caar: "); puthex8(code[curctx].caar);
		putchar('\n');
	}
}

rmodify(buf)
char *buf;
{
char *cp;
char tbuf[80];
int i;
	buf += 2;
	i = reg(buf);
	while(1){
		if(i < 0)
			i = sizeof(rnm)/sizeof(struct rnm) - 2;

		if(i > (sizeof(rnm)/sizeof(struct rnm) - 2))
			i = 0;

		printf("%s: ",rnm[i].nm);
		puthex8(greg(rnm[i].nm));
                putchar(' ');
                gets(tbuf);
                putchar('\n');
                cp = tbuf;
                switch(*cp){
                        case '^': i--; break;
                        case '\0': i++; break;
                        case '=': break;
                        case '.': goto out;
                        default:
                                if(*cp >= '0' && *cp <= '9'
                                        || *cp >= 'A' && *cp <= 'F'
                                        || *cp >= 'a' && *cp <= 'f' )

                                        sreg(rnm[i].nm,hexv(&cp));
                                break;
                }
	}
out:
	return;
}

swctxt(buf)
char *buf;
{
int ctx;
	buf += 2;
	if(*buf)
		ctx = hexv(&buf);
	else
		ctx = 1;
	if(ctx >= 0 && ctx < NCTX){
		curctx = ctx;
		printf("New Context %x\n",curctx);
	}else{
		printf("Context mus be 0 - %d\n",NCTX-1);
	}
}

getctxt()
{
	return(curctx);
}

bset(buf)
char *buf;
{
	buf += 2;
	if(*buf)
		code[curctx].baddr = hexv(&buf);
	else
		code[curctx].baddr = code[curctx].pc;
	code[curctx].binstr = *(unsigned short *)code[curctx].baddr;
}
bclear(buf)
char *buf;
{
	if(code[curctx].baddr){
		*(unsigned short *)code[curctx].baddr = code[curctx].binstr;
		code[curctx].baddr = 0;
	}
}
bdisplay(buf)
char *buf;
{
	printf("Breakpoint at: "); puthex8(code[curctx].baddr);
	printf(" Opcode : "); puthex4(code[curctx].binstr);
	putchar('\n');
}

/*
	trap processing for current context....
	trace -> print pc/sr and continue if trace > 0
	breakpoint -> stop
	other -> stop
	
*/
trap()
{
	switch((state->vector >> 12 ) & 0xf){
		case 0:
		case 1:
			state->ssp += 8; break;
		case 2:
			state->ssp += 12; break;
		case 9:
			state->ssp += 20; break;
		case 10:
			state->ssp += 32; break;
		case 11:
			state->ssp += 92; break;
		default:
			state->ssp += 8; break;
	}

	state->sr &= ~0xc000;	/* turn off tracing */

	if(user)
		statesave(curctx);

	switch(code[curctx].vector & 0x0fff){
		case 0x24:
			if(code[curctx].baddr){
				if(code[curctx].trace){
					*(unsigned short *)code[curctx].baddr = state->binstr;
				}else{
					*(unsigned short *)code[curctx].baddr = 0x4afc;
					staterestore(curctx);
					cont();
				}
			}
			printf("Trace: pc: ");
			puthex8(code[curctx].pc);

			printf(" opcode: ");
			puthex8(*(unsigned long *)code[curctx].pc);

			if(code[curctx].sr & 0x2000){
				printf(" ssp: ");
				puthex8(code[curctx].ssp);
			}else{
				printf(" usp: ");
				puthex8(code[curctx].usp);
			}
			printf(" sr: ");
			puthex4(code[curctx].sr);
			printf("\n");

			if(code[curctx].trace){
				if(--code[curctx].trace){
					/* about to execute a trap ? */
					if((*(unsigned short *)code[curctx].pc & 0xfff0) != 0x4e40)
						
						code[curctx].sr |= 0x8000;
					staterestore(curctx);
					cont();
				}
			}
			break;
		case 0xbc: /* service call to monitor */
			if((*(unsigned short *)code[curctx].pc == 0x0000) ||
				code[curctx].trace){
				printf("Trap: Monitor service %x\n",
					*(unsigned short *)code[curctx].pc);
				if(!code[curctx].trace){
					if( code[curctx].baddr )
						*(unsigned short *)code[curctx].baddr = code[curctx].binstr;
					code[curctx].pc += 2;
					break;
				}
			}

			switch(*(unsigned short *)code[curctx].pc){
				case 0x01:	/* outchar */
					outchar(0,code[curctx].reg[0]);
					break;
				case 0x02:	/* inchar */
					code[curctx].reg[0] = inchar(0);
					break;
				case 0x03:	/* instat */
					code[curctx].reg[0] = instat(0);
					break;
				default:
					printf("Trap: Monitor service %x\n",
						*(unsigned short *)code[curctx].pc);
					break;
			}
			code[curctx].pc += 2;
			if(code[curctx].trace){
				/* about to execute a trap ? */
				if((*(unsigned short *)code[curctx].pc & 0xfff0) != 0x4e40)

					code[curctx].sr |= 0x8000;
			}
			staterestore(curctx);
			cont();
		case 0x10:	/* illegal instruction */
			if(code[curctx].pc == code[curctx].baddr){
				if(*(unsigned short *)code[curctx].pc == 0x4afc){
					/*
						breakpoint
					*/
					*(unsigned short *)code[curctx].baddr = code[curctx].binstr;
					printf("Breakpoint: \n");
					break;
				}
			}
			/* fall through */
		default:
			code[curctx].trace = 0;
			if(code[curctx].baddr)
				*(unsigned short *)code[curctx].baddr = code[curctx].binstr;
			puts("Trap: ");
			puts("Vector: "); puthex4(code[curctx].vector & 0x0fff);
			puts(" Format: "); puthex2((code[curctx].vector >> 12 )& 0xf);
			putchar('\n');
			break;
	}
}

trace(buf)
char *buf;
{
int (*fn)();
	buf+=2;

	if(*buf)
		code[curctx].trace = hexv(&buf);
	else
		code[curctx].trace = 1;
	/* about to execute a trap ? */
	if((*(unsigned short *)code[curctx].pc & 0xfff0) != 0x4e40)
		code[curctx].sr |= 0x8000;
	runat("go");
}
startos(addr,ctx)
unsigned long addr;
int ctx;
{
	curctx = ctx;
	code[curctx].pc = addr;
	code[curctx].sr = 0x2700;
	staterestore(curctx);
	cont();
}
runos(buf)
char *buf;
{
	curctx = 0;
	puthex8(code[curctx].pc);
	putchar('\n');
	staterestore(curctx);
	cont();
}
runat(buf)
char *buf;
{
	buf+=2;
	if(*buf)
		code[curctx].pc = hexv(&buf);

	if(code[curctx].baddr){
		if(code[curctx].pc == code[curctx].baddr){
			/* about to execute breakpoint, trace */
			code[curctx].sr |= 0x8000;
		}else{
			/* install breakpoint, trap will rmeove it */
			code[curctx].binstr = *(unsigned short *)code[curctx].baddr;
			*(unsigned short *)code[curctx].baddr = 0x4afc;
		}
	}


	puthex8(code[curctx].pc);
	putchar('\n');
	cache(0);
	staterestore(curctx);
	cont();
}
statesave(ctx)
int ctx;
{
	code[ctx] = *state;
	user=0;
}
staterestore(ctx)
int ctx;
{
	*state = code[ctx];
	user=1;
}
