#ifndef UBCDH
#define UBCDH

//
//	Definition of character representation
//

#define BITWM 0x80
#define BIT1 1
#define BIT2 2
#define BIT4 4
#define BIT8 8
#define BITA 0x10
#define BITB 0x20
#define BITC 0x40

extern char bcd_ascii[];
extern int ascii_bcd[];

//
//	These are defined so that keyboard input may recognize them
//

#define ASCII_RECORD_MARK	0174
#define ASCII_GROUP_MARK    0316
#define ASCII_SEGMENT_MARK	0327
#define ASCII_RADICAL		0373
#define ASCII_ALT_BLANK		'b'
#define ASCII_WORD_SEPARATOR '^'
#define ASCII_DELTA			0177

class BCD {

private:
	int c;							// WM _ B A 8 4 2 1
    								// (Check bit is not used)
public:
	BCD() { c = 0; }				// Default constructor

    BCD(int i) { c = i; }

	inline int BCDConvert(int ch) {	//	Constructor
        if(ascii_bcd[ch] < 0) {
        	return ascii_bcd[ASCII_ALT_BLANK];
        }
        else {
   			return ascii_bcd[ch];
        }
	}

    inline int BCDCheck(int ch) {
    	return(ascii_bcd[ch]);
    }

	inline char ToAscii() {
    		return bcd_ascii[c];
    }

    inline int ToInt() {
    	return c;
    }

};

#endif
