/************************************************************************
*
* lnkpunch - Punchs out memory for IBM 7090 linker.
*
* Changes:
*   05/21/03   DGP   Original.
*	
************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>

#include "lnkdef.h"

extern FILE *lstfd;
extern int listmode;
extern int pc;
extern int errcount;
extern int absentry;
extern int relentry;
extern Memory memory[MEMSIZE];

static int objcnt = 0;
static int objrecnum = 0;
static char objbuf[16];
static char objrec[82];

/***********************************************************************
* punchfinish - Punch a record with sequence numbers.
***********************************************************************/

static void
punchfinish (FILE *outfd)
{
   sprintf (&objrec[SEQUENCENUM], SEQFORMAT, ++objrecnum);
   fputs (objrec, outfd);
   memset (objrec, ' ', sizeof(objrec));
   objcnt = 0;
}

/***********************************************************************
* punchrecord - Punch an object value into record.
***********************************************************************/

static void 
punchrecord (FILE *outfd)
{
   if (objcnt+WORDTAGLEN >= CHARSPERREC)
   {
      punchfinish (outfd);
   }
   strncpy (&objrec[objcnt], objbuf, WORDTAGLEN);
   objbuf[0] = '\0';
   objcnt += WORDTAGLEN;
}

/***********************************************************************
* punchmemory - Punch out memory.
***********************************************************************/

int
lnkpunch (FILE *outfd)
{
   int i;

   memset (objrec, ' ', sizeof(objrec));
   for (i = 0; i < pc; i++)
   {
      if (memory[i].tag)
      {
         sprintf (objbuf, OBJFORMAT,
		  memory[i].tag, memory[i].memhi, memory[i].memlo);
         punchrecord (outfd);
	 if (memory[i].tag == BSS_TAG) i += memory[i].memlo;
      }
   }

   if (relentry >= 0)
   {
      sprintf (objbuf, OBJFORMAT, RELENTRY_TAG, 0, relentry);
      punchrecord (outfd);
   }

   if (objcnt)
      punchfinish (outfd);

   return (0);
}

