/***********************************************************************
*
* lnkdef.h - Linker header for the IBM 7090 linker.
*
* Changes:
*   05/21/03   DGP   Original.
*	
***********************************************************************/

#include <stdio.h>

/*
** Definitions
*/

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define VERSION "1.0.1"

#define MAXLINE 256
#define LINESPAGE 60
#define MAXFILES 30

#define TEMPSPEC "lnkXXXXXX"

/*
** Object output formats
*/

#define OBJFORMAT "%c%7.7o%5.5o"
#define SEQFORMAT "%6.6d\n"

/*
** Listing formats
*/

#define H1FORMAT "LNK7090 %-8.8s  %-24.24s  %s Page %04d\n\n"

#define MODFORMAT "\n%5.5o %-10.10s %s\n"
#define ENTRYFORMAT "   %5.5o %s \n"

/*
** Data type definitions
*/

#define int8            char
#define int16           short
#define int32           int
typedef int             t_stat;                         /* status */
typedef int             t_bool;                         /* boolean */
typedef unsigned int8   uint8;
typedef unsigned int16  uint16;
typedef unsigned int32  uint32, t_addr;                 /* address */

#if defined (WIN32)                                     /* Windows */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (VMS)                /* Alpha VMS */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (__unix__)           /* Alpha UNIX */
#define t_int64 long
#else                                                   /* default GCC */
#define t_int64 long long
#endif                                                  /* end OS's */
typedef unsigned t_int64        t_uint64, t_value;      /* value */
typedef t_int64                 t_svalue;               /* signed value */

#if defined(__s390__) || defined(OPENMVS) || defined(sparc)
#define MSL 0
#define LSL 1
#else
#define MSL 1
#define LSL 0
#endif

/*
** Memory
*/

#define MEMSIZE 32768

typedef struct
{
   long memhi;
   long memlo;
   char tag;
   int	relocatable;
   int  external;
   int  global;
} Memory;

/*
** Symbol table
*/

#define MAXSYMLEN 6
#define MAXSYMBOLS 2000

typedef struct
{
   char symbol[32];
   char module[32];
   int value;
   int relocatable;
   int external;
   int global;
} SymNode;

/*
** Object tags
*/

#define ORG_TAG		'0'
#define DATA_TAG	'1'
#define BSS_TAG		'2'
#define ABSINST_TAG	'3'
#define RELINST_TAG 	'4'
#define EXTRN_TAG	'5'
#define GLOBAL_TAG	'6'
#define ABSENTRY_TAG	'7'
#define RELENTRY_TAG	'8'

#define CHARSPERREC	66  /* Chars per object record */
#define WORDTAGLEN	13 /* Word + Object Tag length */
#define EXTRNLEN	13 /* Tag + SYMBOL + addr */
#define GLOBALLEN	13 /* Tag + SYMBOL + addr */
#define SEQUENCENUM	74 /* Where to put the sequence */

extern int lnkloader (FILE *, char *, int, int);
extern int lnkpunch (FILE *);
extern void printheader (FILE *);
extern SymNode *symlookup (char *, char *, int);
