/*
 * Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 *
 * NOTE:  under Epoch 4.0, a Root_Block structure exists for each screen...
 *	  For ASCII display, there is only one; for X display, there is one
 *	  for each edit screen and minibuffer (if distinct).  This means that
 *	  Raw X data will actually be meaningless for ASCII.
 *
 * $Revision: 1.1.1.1 $
 * $Source: /bsdi/MASTER/BSDI_OS/contrib/emacs/epoch-src/screen.h,v $
 * $Date: 1992/07/28 00:45:29 $
 * $Author: polk $
 */

#ifndef XPNTR
#include "lisp.h"
#endif
/* Used with X11 includes; use NIL rather than NULL from lisp.h */
struct Root_Block
    {
    int lisp_size;                      /* size of the structure */
    struct Lisp_Vector *lisp_next;	/* vector next */
    /* sheet support */
    Lisp_Object next,prev;		/* links for ring */
    Lisp_Object ewin;			/* root window of screen */
    Lisp_Object select;			/* last selected window */
    Lisp_Object seq;			/* sequence number */
    Lisp_Object stylenorm;	        /* style - normal */
    Lisp_Object stylerev;		/* style - inverse */
    Lisp_Object stylecursor;		/* style - cursor? */
    /* these next two are Raw Data, and have to be handled internally */
    Lisp_Object x11;                    /* sheet for x-window display */
    Lisp_Object win;                    /* display data */
    Lisp_Object update;			/* update when not current? */
    Lisp_Object motion_hints;		/* motion hints enabled? */
    Lisp_Object needs_update;		/* munged, needs updated */
    Lisp_Object needs_display;	        /* layout done, need to display */
    Lisp_Object minibuf_window;		/* pointer to minibuffer window */
    Lisp_Object prev_select;		/* previously selected window */
    } ;

#define XROOT(a)        ( (struct Root_Block *) XPNTR(a) )
#define ROOTP(a)	( XTYPE((a)) == Lisp_Root_Block )

extern Lisp_Object Qepoch_screenp;
#define CHECK_SCREEN(x, i) \
  { if (XTYPE ((x)) != Lisp_Root_Block) x = wrong_type_argument (Qepoch_screenp, (x)); }

#define XA_EPOCH_CURRENT	"EPOCH_CURRENT"
#define XA_EPOCH_SCREEN_ID	"EPOCH_SCREEN_ID"
/* - - - - - - - - - - - - - - - - - - - - - */
/* useful macros */
#define EDIT_SCREEN (XWINDOW(XWINDOW(minibuf_window)->prev)->root) 

/* fix up the window pointer in the root block */
#define RW_FIXUP(rb)    { register Lisp_Object pw;\
			      while ((pw=XWINDOW((rb)->ewin)->parent)\
				     != (rb)->ewin && !NIL(pw))\
			          (rb)->ewin = pw;\
			}

/* ------------------------------------------------------------------------ */
extern struct Root_Block *root;		/* Anchor to display structure */
extern struct Root_Block *mini_root; 	/* Minibuffer screen (or Nil) */
extern struct Root_Block *cur_root; 	/* Current edit screen */

extern int screen_changed;	/* set if some screen needs updating */

