/* $Header: /usr/src/bin/adb.rt/RCS/defs.h,v 1.3 1994/05/21 11:42:04 roger Exp $ */
/* $ACIS:defs.h 12.0$ */
/* $Source: /usr/src/bin/adb.rt/RCS/defs.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsiddefs = "$Header: /usr/src/bin/adb.rt/RCS/defs.h,v 1.3 1994/05/21 11:42:04 roger Exp $";
#endif

/*      defs.h  4.3     82/12/19        */
/*
 * adb - vax string table version; common definitions
 */
#include <machine/pte.h>
#include <sys/param.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/ptrace.h>
#include <ctype.h>
#include <a.out.h>
#include "mac.h"
#include "mode.h"
#include "head.h"

/* access modes */
#define RD      0
#define WT      1
#define NSP     0
#define ISP     1
#define DSP     2
#define STAR    4
#define STARCOM 0200
/*
 * Symbol types, used internally in calls to findsym routine.
 * On the VAX this all degenerates since I & D symbols are indistinct.
 * Basically we get NSYM==0 for = command, ISYM==DSYM otherwise.
 */
#define NSYM    0
#define DSYM    1               /* Data space symbol */
#define ISYM    DSYM            /* Instruction space symbol == DSYM on VAX */

#define BKPTSET 1
#define BKPTEXEC 2

#define USERPS  PSL
#define USERPC  PC

#define BPT 0xBD00                  /* trap (breakpoint) inst */
#define BPMASK 0xFFFF               /* mask for clearing word to OR in BPT */

/* These values must match the switch statement in kernel routine procxmt */

#define SETTRC  0
#define RDUSER  2
#define RIUSER  1
#define WDUSER  5
#define WIUSER  4
#define RUREGS  3
#define WUREGS  6
#define CONTIN  7
#define EXIT    8
#define SINGLE  9

/* variables in the u area are accessed by their offset into the u area */

#define USTRUCT (UPAGES*NBPG - sizeof(struct user))

#define MAXREGNO    16
#include "offsets.h"	/* offsets from USTRUCT constructed by Mkoffset */
/* here's some mystical stuff */

#ifdef ibm032	/* a nice large offset from symbols */
#define MAXOFF  0xffff
#else
#define MAXOFF  0x8000
#endif
#define MAXPOS  80
#define MAXLIN  128
#define EOR     '\n'
#define QUOTE   0200
#define EVEN    (-2)

#define ONEBYTE(i) ((unsigned)(i)>>24)  /* assumes argument is a long */

#define shorten(a)      ((short)(a))

/* result type declarations */

L_INT           inkdot();
POS             get();
POS             chkget();
STRING          exform();
L_INT           round();
unsigned long	addr_round();
ABKPTR          scanbkpt();
VOID            fault();
ADDR		traceOffStack();
struct  pcb     pcb;
struct  proc     proc;
int     kernel;
int     kcore;
struct  pte *sbr;
int     slr;
int     masterpcbb;
#ifdef ibm032
#include <machine/mmu.h>
int MMU_HASHMASK;
int endmem;	 /* in clicks */
struct hatipt_entry *MMU_HATIPT;
#endif

ADDR StackBottom;	/* Kernel's view of Bottom (low addr) of stack for
			 *running process. */

ADDR DataTop;		/* Kernel's view of highest virtual data address. */

#define symTableIsPresent(dummy)	filhdr.a_syms

int 	debug;
#ifdef DEBUG
#define dprintf(x)	if(debug) printf x
#else
#define dprintf(x)
#endif

#define User_iar	*(ADDR *)(((ADDR)&u)+getRegByName("iar"))
#define Kernel_iar	user.u_pcb.pcb_iar

extern struct user user;

int Uadjust;
