/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:mpeltty.h 12.0$ */
/* $ACIS:mpeltty.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/mpeltty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidmpeltty = "$Header:mpeltty.h 12.0$";
#endif

/*
 * Screen dimensions 
 */
#define MPEL_SCREEN_WD	1024			/* screen height */
#define MPEL_SCREEN_HT	1024			/* screen width */
#define MPEL_MAX_X	(MPEL_SCREEN_WD - 1)	/* max x pixel */
#define MPEL_MAX_Y	(MPEL_SCREEN_HT - 1)	/* max y pixel */
#define MPEL_FONT_Y	30			/* font size 12 x 30*/
#define MPEL_FONT_X	12
/*
 * the next two defines set the character size limits on the screen.
 * These must match the values set in screen_conf.c.
 * MPEL_COLUMNS must be >= 1 and <= 85, MPEL_ROWS must be >= 1 <= 34
 */
#define MPEL_COLUMNS	80
#define MPEL_ROWS	34

/*
 * These defines are created from the screen dimensions, and the
 * desired characters per screen.
 */
#define	MPEL_X_START	((MPEL_SCREEN_WD - MPEL_COLUMNS*MPEL_FONT_X)/2)
#define	MPEL_Y_END	((MPEL_SCREEN_HT + (MPEL_ROWS-2)*MPEL_FONT_Y)/2)
#define MPEL_TO_Y(x)	(MPEL_Y_END-(x)*MPEL_FONT_Y)
#define MPEL_TO_X(x)	(MPEL_X_START+(x)*MPEL_FONT_X)

/*
 * Frame Buffer Address.
 */
#define MPEL_MCODE_MAGIC	0xff80
#define IO_ADDR 0xF0000000
#define MODEL_IO_ADDR	(IO_ADDR | 0x04000000)
#define MPELBASE (MODEL_IO_ADDR | 0x00C00000)

/*
 * Primary Control Register (PCR) (Read/Write)
 */

#define PCR_R	(IO_ADDR | 0x0948)
#define RESET_MPEL	*(unsigned short *)PCR_R = 0 

#define HOLD_BIT		0x0100
#define SET_HOLD_BIT		*(unsigned short*)(PCR_R) |= HOLD_BIT
#define RESET_HOLD_BIT		*(unsigned short*)(PCR_R) &= ~HOLD_BIT

#define TMS_BIT			0x0200
#define SET_TMS_BIT		*(unsigned short*)(PCR_R) |= TMS_BIT
#define RESET_TMS_BIT		*(unsigned short*)(PCR_R) &= ~TMS_BIT

#define INT_TMS_BIT		0x0400
#define SET_INT_TMS_BIT		*(unsigned short*)(PCR_R) |= INT_TMS_BIT
#define RESET_INT_TMS_BIT	*(unsigned short*)(PCR_R) &= ~INT_TMS_BIT

#define SELECT_BIT		0x0800
#define SET_SELECT_BIT		*(unsigned short*)(PCR_R) |= SELECT_BIT
#define RESET_SELECT_BIT	*(unsigned short*)(PCR_R) &= ~SELECT_BIT

#define ENABLE_DMA_BIT		0x4000
#define ENABLE_DMA		*(unsigned short*)(PCR_R) |= ENABLE_DMA_BIT
#define DISABLE_DMA		*(unsigned short*)(PCR_R) &= ~ENABLE_DMA_BIT

#define ENABLE_TMS_INT		0x0001
#define ENABLE_TMS		*(unsigned short*)(PCR_R) |= ENABLE_TMS_INT
#define DISABLE_TMS		*(unsigned short*)(PCR_R) &= ~ENABLE_TMS_INT

#define ENABLE_FIFO_INT		0x0004
#define ENABLE_FIFO		*(unsigned short*)(PCR_R) |= ENABLE_FIFO_INT
#define DISABLE_FIFO		*(unsigned short*)(PCR_R) &= ~ENABLE_FIFO_INT

#define INTERRUPT_BITS		0x001F
#define ENABLE_INTERRUPT	*(unsigned short*)(PCR_R) |= INTERRUPT_BITS
#define DISABLE_INTERRUPT	*(unsigned short*)(PCR_R) &= ~ INTERRUPT_BITS

/*
 * Primary Status Register (PSR) (Read Only)
 */

#define PSR_R	(IO_ADDR | 0x094a)
#define STATUS_MPEL(reg)	reg = *(unsigned short *)PSR_R
#define PSR_NOTHOLD_BIT	0x0100
#define PSR_INTPEND_BIT	0x0200
#define PSR_FIFO_NFULL_BIT	0x2000
#define PSR_FIFO_NHALF_BIT	0x4000
#define PSR_FIFO_NEMPT_BIT	0x8000

/*
 * Interrupt Pending Register (IPR) (Read Only)
 */

#define IPR_R	(IO_ADDR | 0x0940)
#define INTER_MPEL(reg)	reg = *(unsigned short *)IPR_R
#define IPR_TMSINT_BIT	0x0001

/*
 * FIFO Input Register (FIFO) (Write Only)
 */

#define FIR_R	(IO_ADDR | 0x094e)

/*
 * COMM Area pointer
 */

#define COMM_POINTER	(MODEL_IO_ADDR | 0x00c008e0)
#define SET_COMM_AREA	*(unsigned int *)(COMM_POINTER) = 0x00000480
#define COMM_AREA	(MODEL_IO_ADDR | 0xc00900)
#define APDA_REQUEST	(MODEL_IO_ADDR | 0xc00902)
#define DAAP_REASON	(MODEL_IO_ADDR | 0xc00904)
#define COMM_REQ_PARAM	(MODEL_IO_ADDR | 0xc00954)
#define COMM_REA_PARAM	(MODEL_IO_ADDR | 0xc00960)
#define ushort unsigned short

struct ap_da_comm_area {
	ushort res0;
	ushort req;
	ushort reason;
	ushort pick;
	char *state_p;
	ushort res1[10];
	char *atf_p;
	char *pcs_p;
	ushort res2[2];
	ushort data_flag;
	ushort tablet_status0;
	ushort tablet_buttons0;
	ushort res3;
	ushort tablet_x0;
	ushort res4;
	ushort tablet_y0;
	ushort tablet_z0[2];
	ushort tablet_status1;
	ushort tablet_buttons1;
	ushort res5;
	ushort tablet_x1;
	ushort res6;
	ushort tablet_y1;
	ushort tablet_z1[2];
	ushort res7[3];
	ushort req_pars[6];
	ushort res_pars[10];
};

/*
 * COMM Area Limits
 */

#define DATA_BASE	(MODEL_IO_ADDR | 0x00c00000)
#define DATA_END	(MODEL_IO_ADDR | 0x00c3ffff)

/*
 * PROGRAM Area Limits
 */

#define PGM_BASE	(MODEL_IO_ADDR | 0x00d60000)
#define PGM_END		(MODEL_IO_ADDR | 0x00d7ffff)

/*
 * Data Spaces
 */

/* Circle Table */
#define CIRTAB	(MODEL_IO_ADDR | 0xc01e00)

/* Sine Table */
#define SINTAB	(MODEL_IO_ADDR | 0xc02e00)

/* Marker Location Table */
#define MARKID	(MODEL_IO_ADDR | 0xc07360)

/* Hatch Table */
#define HCHTAB	(MODEL_IO_ADDR | 0xc07ca0)

/* Marker Font Data */
#define MARKER	(MODEL_IO_ADDR | 0xc04f00)

/*
 * Program Space
 */

/* Microcode */
#define MCODE	(MODEL_IO_ADDR | 0xd60000)

/*
 * Annotation Text Font Location Table pointer
 */

#define MFONT			(MODEL_IO_ADDR | 0x00c10ec0)
#define ATF_POINTER		(MODEL_IO_ADDR | 0x00c00920)
#define ATF_TABLE_AF		0x01008756
#define ATF_TABLE_SF		(MODEL_IO_ADDR | 0x00c10eac)
#define SET_ATF_POINTER		*(unsigned int *)(ATF_POINTER) = 0x01008756
#define SET_ATF_COUNT		*(unsigned int *)(ATF_TABLE_SF) = 0x00070001
#define SET_ATF_FONTADDR	*(unsigned int *)(ATF_TABLE_SF+4) = 0x01008760

/*
 * Programmable Character Set Font Location Table pointer
 */

#define PCS_POINTER (MODEL_IO_ADDR | 0x00c00924)

/*
 * Color Table offset
 */

#define COLOR_TABLE	0x00c07db0
#define CURSOR_BITMAP	0x00c10044
#define HWCURSOR_BITMAP	0x00c100f8
#define	GET_RED(x)	(((x) >> 20) & 0xf)
#define	GET_GREEN(x)	(((x) >> 12) & 0xf)
#define	GET_BLUE(x)	(((x) >> 4) & 0xf)

/*
 * Define constants and global delclarations
 */
#define MAXRETRY 500
#define HDELAY_ADDR (IO_ADDR | 0x80e0) /*delay address */
#define AP_DA_Request *(unsigned short *)(APDA_REQUEST)
#define FIFO *(unsigned short *)(FIR_R)
#define HDELAY *(unsigned short *)(HDELAY_ADDR)


/*
 * AP Requests
 */

#define RQ_ENTER_FIFO	0x0002
#define RQ_ACT_CURSOR	0x0010
#define RQ_DEF_CURSOR	0x0012
#define RQ_REM_CURSOR	0x0014
#define RQ_CLEAR_FRAM	0x0016
#define RQ_LOAD_CTABL	0x0020
#define RQ_FLUSH_FIFO	0x0022
#define RQ_SET_BLINK	0x020c
