/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:mono_tcap.h 11.0$ */
/* $ACIS:mono_tcap.h 11.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/mono_tcap.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidmono_tcap = "$Header:mono_tcap.h 11.0$";
#endif

/*
 * the following defines specify the escape sequences used by the
 * ibm3101 emulator (used for ibmconsole, ibmapa8, ibmapa16 devices)
 * The cryptic codes are (generally) the termcap names for the particular
 * function.
 */

#define ESC_FOUND 0x100 	       /* flag for escape found */
#define ESC_(x) ESC_FOUND+'x'           /* ESC + x */

#define UP_CHAR ESC_(A) 		/* ESC A cursor up */
#define CL_CHAR ESC_(K) 		/* ESC K clear screen */
#define ND_CHAR ESC_(C) 		/* ESC C non-destructive space */
#define CD_CHAR ESC_(J) 		/* ESC J clear to end of screen */
#define CE_CHAR ESC_(I) 		/* ESC I clear to end of line */
#define HO_CHAR ESC_(H) 		/* ESC H home cursor */
#define CM_CHAR2 ESC_(Y)		/* ESC Y x y */
#define SO_CHAR ESC_(p) 		/* ESC p stand out */
#define SE_CHAR ESC_(q) 		/* ESC q stand out end */
#define HI_CHAR ESC_(Z) 		/* ESC Z hi intensity */
#define LO_CHAR ESC_(z) 		/* ESC z lo intensity */
#define US_CHAR ESC_(W) 		/* ESC W start underline */
#define UE_CHAR ESC_(w) 		/* ESC w stop underline */
#define SH_CHAR ESC_(s) 		/* ESC s status line on/off */
#define SAVE_CM ESC_(j) 		/* ESC j save cursor position */
#define RESTORE_CM ESC_(k)		/* ESC k restore cursor position */
#define AL_CHAR ESC_(L) 		/* ESC L insert line */
#define DL_CHAR ESC_(M) 		/* ESC M delete line */
#define IGN_CHAR	ESC_([) 	/* ESC [ ==> ESC */
#define CURSOR_OFFSET	' '            /* blank is normal offset value */

#ifdef IBMRTPC
/*
 * the following defines specify the escape sequences used by the
 * ibm3101 emulator for the color support for the ega device when in
 * one of its color modes.
 */

#define FR_GRND 	ESC_(U) 	/* ESC U change foreground color   F3 */
#define BK_GRND 	ESC_(V) 	/* ESC V change background color   F4 */

#else /* ATR system */
/*
 * the following defines specify the escape sequences used by the
 * ibm3101 emulator for the color support
 */

/* from ibm_emul.h */
#define FR_GRND 	ESC_(U) 	/* ESC U inc foreground color */
#define BK_GRND 	ESC_(V) 	/* ESC V inc background color */
#define FR_DEC		ESC_(u) 	/* ESC U dec foreground color */
#define BK_DEC		ESC_(v) 	/* ESC V dec background color */
#define CT_CHAR 	ESC_(T) 	/* ESC T tab;red;green;blue; colr tab */
#define FG_CHAR 	ESC_(f) 	/* ESC f tab; change fg color */
#define BG_CHAR 	ESC_(b) 	/* ESC b tab; change bg color */
#define CL_SAVE 	ESC_(F) 	/* ESC F save current fg/bg entry */
#define CL_RSTR 	ESC_(B) 	/* ESC B restore old fg/bg entry */

/* new for ATR systems */
#define BS_CHAR 	  ESC_(G)	/* ESC G blink/bgrnd intense	  PgUp*/
#define BE_CHAR 	  ESC_(E)	/* ESC E blink/bgrnd intense end  PgDn*/
#define REVERSE 	  ESC_(P)	/* ESC P reverse fgrnd and bgrnd   F6 */
#define BLINK_ENABLE	  ESC_(Q)	/* ESC Q enable blinking	   F7 */
#define BG_HI_ENABLE	  ESC_(R)	/* ESC R enable fgrnd hi intensity F8 */
#define CHG_DISPLAY_MODE  ESC_(<)	/* ESC < change display mode	   F10*/

#endif IBMRTPC

#ifndef lint
static char term_type[] = "ibm3101";
#endif
