/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:authunix_prot.c 12.0$ */
/* $ACIS:authunix_prot.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/rpc/RCS/authunix_prot.c,v $ */

#ifndef lint
static char *rcsid = "$Header:authunix_prot.c 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

#ifdef NFS

/* @(#)authunix_prot.c	1.6 87/09/18 3.2/4.3NFSSRC */
/* @(#)authunix_prot.c	1.3 86/12/23 NFSSRC */
#ifndef lint
static char sccsid[] = "@(#)authunix_prot.c 1.1 86/09/24 Copyr 1984 Sun Micro";
#endif

/*
 * authunix_prot.c
 * XDR for UNIX style authentication parameters for RPC
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#ifdef KERNEL
#include "param.h"
#include "systm.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#include "proc.h"

#include "../rpc/types.h"
#include "../rpc/xdr.h"
#include "../rpc/auth.h"
#include "../rpc/auth_unix.h"
#else
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/auth_unix.h>
#endif

/*
 * XDR for unix authentication parameters.
 */
bool_t
xdr_authunix_parms(xdrs, p)
	register XDR *xdrs;
	register struct authunix_parms *p;
{

	if (xdr_u_long(xdrs, &(p->aup_time))
	    && xdr_string(xdrs, &(p->aup_machname), MAX_MACHINE_NAME)
	    && xdr_int(xdrs, &(p->aup_uid))
	    && xdr_int(xdrs, &(p->aup_gid))
	    && xdr_array(xdrs, (caddr_t *)&(p->aup_gids),
		    &(p->aup_len), NGRPS, sizeof(int), xdr_int) ) {
		return (TRUE);
	}
	return (FALSE);
}

#ifdef KERNEL
/*
 * XDR kernel unix auth parameters.
 * Goes out of the u struct directly.
 * NOTE: this is an XDR_ENCODE only routine.
 */
xdr_authkern(xdrs)
	register XDR *xdrs;
{
	gid_t	*gp;
	int	 uid = (int)u.u_uid;
	int	 gid = (int)u.u_gid;
	int	 len;
	int	*lp;
	int	 groups[NGRPS];
	char	*name = hostname;

	if (xdrs->x_op != XDR_ENCODE) {
		return (FALSE);
	}

	for (gp = &u.u_groups[NGRPS]; gp > u.u_groups; gp--) {
		if (gp[-1] != NOGROUP) {
			break;
		}
	}
	len = gp - u.u_groups;
	for (lp = groups, gp = u.u_groups; lp < &groups[len]; gp++, lp++ )
                *lp = (int) *gp;

	lp = groups;
        if (xdr_u_long(xdrs, (u_long *)&time.tv_sec)
            && xdr_string(xdrs, &name, MAX_MACHINE_NAME)
            && xdr_int(xdrs, &uid)
            && xdr_int(xdrs, &gid)
	    && xdr_array(xdrs, (caddr_t *)&lp, (u_int *)&len, NGRPS,
	       sizeof (int), xdr_int) ) {
			return (TRUE);
	}
	return (FALSE);
}
#endif

#endif
