/* $Header:bios.h 12.0$ */
/* $ACIS:bios.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/bios.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidbios = "$Header:bios.h 12.0$";
#endif

/*
 * $Header:bios.h 12.0$
 * $ACIS:bios.h 12.0$
 *
 * Bios Data area painfully typed in by George R Linscott with assistance
 * from Doug Carter.
 */

#include <sys/types.h>

#define BIOSDATA 0x00400000
#define DISK_BASE 0x1e		/* Bios vector where diskette params are */

struct bios_data		/* At segment 40:0000 */
{
	 /* 0000 */ u_short rs232_base[4];
	 /* 0008 */ u_short printer_base[4];
	 /* 0010 */ u_short equip_flag;
	 /* 0012 */ char mfg_test;
	 /* 0013 */ u_short memory_size;
	 /* 0015 */ char mfg_err_flag[2];

	/*
	 * Keyboard Data Areas 
	 */

	 /* 0017 */ char kb_flag;
	 /* 0018 */ char kb_flag_1;
	 /* 0019 */ char alt_input;
	 /* 001a */ u_short buffer_head;
	 /* 001c */ u_short buffer_tail;
	 /* 001e */ u_short kb_buffer[16];

/*
 * Diskette Data Area
 */

	 /* 003e */ char seek_status;
	 /* 003f */ char motor_status;
	 /* 0040 */ char motor_count;
	 /* 0041 */ char diskette_status;
	 /* 0042 */ char nec_status[7];

/*
 * Video Display Data Area
 */

	 /* 0049 */ char crt_mode;
	 /* 004a */ u_short crt_cols;
	 /* 004c */ u_short crt_len;
	 /* 004e */ u_short crt_start;
	 /* 0050 */ u_short cursor_posn[8];
	 /* 0060 */ u_short cursor_mode;
	 /* 0062 */ char active_page;
	 /* 0063 */ u_short addr_6845;
	 /* 0065 */ char crt_mode_set;
	 /* 0066 */ char crt_pallette;

/*
 * POST Data Area
 */

	 /* 0067 */ u_short io_rom_init;
	 /* 0069 */ u_short io_rom_seg;
	 /* 006b */ char intr_flag;

/*
 * Timer Data Area
 */

	 /* 006c */ u_short timer_low;
	 /* 006e */ u_short timer_high;
	 /* 0070 */ char timer_ofl;

/*
 * System Data ARea
 */

	 /* 0071 */ char bios_break;
	 /* 0072 */ u_short reset_flag;

/*
 * Hard file data Area
 */

	 /* 0074 */ char disk_status1;
	 /* 0075 */ char hf_num;
	 /* 0076 */ char crtl_byte;
	 /* 0077 */ char port_off;

/*
 * Printer and rs232 timeout variables
 */

	 /* 0078 */ char print_tim_out[4];
	 /* 007c */ char rs232_tim_out[4];

/*
 * Addition KB data area
 */

	 /* 0080 */ u_short buffer_start;
	 /* 0082 */ u_short buffer_end;

/*
 *  Additional floppy data
 */

	 /* 0084 */ char pad1[3];
	 /* 0087 */ char egasw1;
	 /* 0088 */ char egasw2;
	 /* 0089 */ char pad2[2];
	 /* 008b */ char lastrate;

/*
 * Additional hard file data
 */

	 /* 008c */ char hf_status;
	 /* 008d */ char hf_error;
	 /* 008e */ char hf_int_flag;
	 /* 008f */ char hf_cntrl;

/*
 * Additional diskette area
 */

	 /* 0090 */ char dsk_state[4];
	 /* 0094 */ char dks_trk[3];

/*
 * Additional KB led flags
 */
	 /* 0097 */ char kb_flag_2;

/*
 * Real time clock data area
 */
	 /* 0098 */ u_short usr_flag;
	 /* 009a */ u_short usr_flag_seg;
	 /* 009c */ u_short rtc_low;
	 /* 009e */ u_short rtc_high;
	 /* 00a0 */ char rtc_wait_flag;
};

struct fixed_disk_param
{
	 /* 000 */ u_short maxcyl;
	 /* 002 */ char maxheads;
	 /* 003 */ u_short notused;
	 /* 005 */ u_short write_precomp;
	 /* 007 */ char maxeccburst;
	 /* 008 */ char ctrl;
	 /* 009 */ char notused2[3];
	 /* 00c */ u_short landing_zone;
	 /* 00e */ char numsec_per_track;
	 /* 00f */ char rfu;
};

/*
 * Diskette Paramaters: This vector points to a data region containing
 * the parameters required for the diskette drive. The power-on routines
 * initialize this vector to point to the parameters contained in the ROM
 * diskette routine. These default parameters represent the specified
 * values for any IBM drives attached to the system. Changing this
 * parameter block may be necessary to reflect the specifications of other
 * drives attached.
 */

struct dbt
{
	char            spec_byte1;
	char            spec_byte2;
	char            wait_time;
	char            bps;	/* Bytes per sector */
	char            last_sec;
	char            gap_len_rdwr;
	char            data_len;
	char            gap_len_fmt;
	char            fill_byte_fmt;
	char            head_settle_time;
	char            motor_startup;
};
