/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:lan.c 12.0$ */
/* $ACIS:lan.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/os2code/RCS/lan.c,v $ */

/*
 * Copyright University of Southern California, 1988
 */

/* OS/2 Monitor Token Ring Interface
 */

#include <doscalls.h>
#include <subcalls.h>
#include <dos.h>
#include <memory.h>
#include "pctype.h"
#include "pcparam.h"
#include "rb.h"
#include "os2ioctl.h"
#include "sem.h"
#include "os2data.h"
#include "lan.h"
#include "thread.h"

/* per adapter information */
static struct lan_adapter lan[NO_LANS] = { { PRIMARY_LAN, }, { ALT_LAN, } };
static int	no_lans = 0;

/* This function spawns the thread for the lan. */

int
lan_init()

{
	int	i;
	int	rc;
	u_char	c;
	struct reg_tr_adapters tr_adapter;

	/* read ports to determine the ram address and the interrupt level */

	no_lans = 0;
	for ( i = 0; i < NO_LANS; i++ ){
		if ( (c = (u_char) IOIN(lan[i].port)) != 0xff ){
			no_lans++;

			/* get the rom addr */
			lan[i].mmio_addr = LAN_MMIO_ADDR(lan[i].port);
			/* get the ram addr */
			lan[i].ram_addr = LAN_RAM_ADDR(lan[i].port);
			/* get the intr level */
			lan[i].intr_level = LAN_INT_TYPE(lan[i].port);
			lan[i].intr_level = LAN_INT_TTOLVL(lan[i].intr_level);

			/* enable the passing of this interrupt to UNIX */
			vec_map[lan[i].intr_level] = 1;

			/* cascade redirect of interrupt level 2 */
			if ( lan[i].intr_level == 2 )
				lan[i].intr_level = 9;
#ifdef LAN_DEBUG
			printf("lan found at 0x%x ", lan[i].port);
			printf("intr: %d ROM: 0x%lx RAM: 0x%lx\n",
				lan[i].intr_level,lan[i].mmio_addr,
				lan[i].ram_addr);
#endif
		}
	}
	if ( no_lans == 0 ) {
		printf("No Lan Adapter Cards found\n");
		return -1;
	}
	tr_adapter.status = 0;
	tr_adapter.no_adapters = no_lans;
	for ( i=0; i < no_lans; i++ ) {
		tr_adapter.tr_adap_params[i].intr_level=lan[i].intr_level;
		tr_adapter.tr_adap_params[i].high= HIGH_WORD(lan[i].mmio_addr);
		tr_adapter.tr_adap_params[i].low = LOW_WORD(lan[i].mmio_addr);
	}

	/* register the cards with the driver */
	if( rc=DOSDEVIOCTL(0,(char far *)&tr_adapter,REG_TR_ADAPTERS,
						PCIF_CAT,pcif_handle)){
		printf("lan_init: DOSDEVIOCTL returned %d\n",rc);
		printf("lan_init: status = 0x%x\n",tr_adapter.status);
		return -1;
	}

#ifdef LAN_DEBUG
	printf("Driver registered %d cards\n", tr_adapter.no_adapters);
#endif

	return 1;
}

/* function to unconditionally reset the lan devices */

int
reset_lan_devices()
{
	int i;

	for ( i=0; i < no_lans; i++ ) {
		LAN_RESET(lan[i].port);
	}
	return 1;
}
