#!/bin/sh -
# $Header:mount_root.sh 12.0$ 
# $ACIS:mount_root.sh 12.0$ 
# $Source: /ibm/acis/usr/sys/dist/etc/RCS/mount_root.sh,v $ 
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#

#
#	Shell script to start up the network and
#	mount up an NFS file system on /root.
#

PATH=/etc:/bin:/etc/minimal
export PATH

#
# Default output to the console.
#
exec >/dev/console 2>&1

# Are we already done?
if test -d /root/lib
then
	# Use ps to find out if routed is running.
	# If ps doesn't work, then worst case is we
	# try (and fail) to start up a second routed.
	# Ps is most likely available now, or the
	# above "if" would have failed.
	if [ "`ps auxc 2>&1 | grep -c routed`" = 0 ]
	then
		/etc/routed
	fi
	exit 0
fi
#
# If rc.config exists, then use
# its network parameters.
#
if test -r /etc/rc.config; then
	. /etc/rc.config
fi
network="${network-un0}"
hostname="${hostname-master}"

#
# Start up the net.
# NFS requires that the hostname
# be set.
echo -n 'starting network...'

#
# Start up the net.
#
hostname ${hostname}
ifconfig ${network} inet ${hostname} ${net_flags}
ifconfig lo0 localhost

#
# Make sure we can get packs up through a gateway
#
routed
syscall sleep 30

echo ""
echo "mounting NFS /root file system..."

#
# Zero out the mount table
#
>/etc/mtab
mount -vf /

#
# Attempt to mount the NFS /root
# file system.
#
mount -v /root

#
# Sync the disks.  We've been writing
# to /etc/mtab, and we don't want that
# to get undone by fsck.
#

sync

#
# Make sure we succeeded in mounting
# /root.  If not, exit with a non-zero
# exit status so rc knows something went
# wrong.
#

if test -d /root/lib
then
  exit 0
else
  echo "Can't mount root network file system."
  echo "fix the problem and press <CTRL>-D"
  echo "to continue."
  exit 1
fi
