/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ieeetrap.h 12.0$ */
/* $ACIS:ieeetrap.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/ieeetrap.h,v $ */

#if !defined(aiws) && !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidieeetrap = "$Header:ieeetrap.h 12.0$";
#endif

/* @(#)ieeetrap.h       7.2 - 87/12/15 - 09:10:33 */
#ifndef _h_IEEETRAP
#define _h_IEEETRAP

#ifdef KERNEL
#include "../machine/fp.h"
#include "../machine/fpfp.h"
#else KERNEL
#include <machine/fp.h>
#include <machine/fpfp.h>
#endif KERNEL

/*
 * Number of double precision floating point registers at release 1.0
 * and 1.1 time.
 */

#define NDPFPREGS 8	

typedef union {
	struct {
		unsigned long hp;
		unsigned long lp;
	} u;
	double d;
	float freg[2];
} fpreg;		/* double, floats, longs */

typedef struct {
	unsigned int operation:8;
	unsigned int rsvd0:2;
	unsigned int src:6;
	unsigned int dest_loc:1;
	unsigned int dest_inv:1;
	unsigned int dest:6;
	unsigned int except_flags:5;
	unsigned int except_type:3;
} fptrapinfo;

typedef struct {
	fptrapinfo fptrapinfo;
	fpreg designated_result;
} fptrap;

typedef struct {
	fpreg fpreg[NDPFPREGS];
	FP_STATUS statusreg;
	fptrap fptrap;
	fpreg fpregup[24];       /* upper 24 fp regs for release 2.1 onward */
	unsigned int *dest_addr; /* address of destination if dest_loc = 1  */
	unsigned int dmalength;  /* saved value of dma length register      */
} fpvmach;

#endif  _h_IEEETRAP
