/* $Header:shiftc_l.c 12.0$ */
/* $ACIS:shiftc_l.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libF77/RCS/shiftc_l.c,v $ */

#ifndef lint
static char *rcsid = "$Header:shiftc_l.c 12.0$";
#endif

/* @(#)shiftc_l.c	5.1 - 86/12/09 - 09:12:52 */
#include "bit.h"

/* Circular shift - The right most ic bits are shifted circularly k-places.
 * k > 0 => left shift.
 * k < 0 => right shift.
 * k = 0 => no shift.
 *	left shift			 right shift
 *	[  b1   |   k2   |   d   ]       [  b1   |   d   |   k2   ]
 */

long shftc_l(m,k,ic)
long *m, *k, *ic;
{
	register unsigned long temp, tempic, k2;
	register unsigned long b1, b2, b3, d;
	register short left;

	left = (*k > 0);
	k2 = left ? *k : -*k;
	temp = *m;
	tempic = *ic;
	if (k2 == 0 || k2 > NBLI || k2 > tempic || tempic < 1 || tempic > NBLI)
		return(temp);
	d = (tempic - k2);
	b1 = temp & ~((1<<tempic) - 1); /* ~F77mask[tempic];*/             /* mask off left most bits */

	if (left) {
		b2 = (temp & F77mask[d]) << k2;   /* get k2 bits */
		b3 = (temp & F77mask[tempic]) >> d;  /* get d bits  */
		}
	else {
		b2 = (temp & F77mask[k2]) << d;   /* get k2 bits */
		b3 = (temp & F77mask[tempic]) >> k2; /* get d bits  */
		}
	return( b1 | b2 | b3 );
}
