/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:syscalls.c 12.0$ */
/* $ACIS:syscalls.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/sys/RCS/syscalls.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid_syscalls = "$Header:syscalls.c 12.0$";
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)syscalls.c	7.1 (Berkeley) 6/5/86
 */

/*
 * System call names.
 */
char *syscallnames[] = {
	"indir",		/*   0 = indir */
	"exit",			/*   1 = exit */
	"fork",			/*   2 = fork */
	"read",			/*   3 = read */
	"write",		/*   4 = write */
	"open",			/*   5 = open */
	"close",		/*   6 = close */
	"old wait",		/*   7 = old wait */
	"creat",		/*   8 = creat */
	"link",			/*   9 = link */
	"unlink",		/*  10 = unlink */
	"execv",		/*  11 = execv */
	"chdir",		/*  12 = chdir */
	"old time",		/*  13 = old time */
	"mknod",		/*  14 = mknod */
	"chmod",		/*  15 = chmod */
	"chown",		/*  16 = chown; now 3 args */
	"old break",		/*  17 = old break */
	"old stat",		/*  18 = old stat */
	"lseek",		/*  19 = lseek */
	"getpid",		/*  20 = getpid */
#ifdef VFS
	"mount",		/*  21 = old mount */
#else VFS
	"mount",		/*  21 = mount */
#endif VFS
	"umount",		/*  22 = umount */
	"old setuid",		/*  23 = old setuid */
	"getuid",		/*  24 = getuid */
	"old stime",		/*  25 = old stime */
	"ptrace",		/*  26 = ptrace */
	"old alarm",		/*  27 = old alarm */
	"old fstat",		/*  28 = old fstat */
	"old pause",		/*  29 = old pause */
	"old utime",		/*  30 = old utime */
	"old stty - nosys",	/*  31 = old stty */
	"old gtty - nosys",	/*  32 = old gtty */
	"access",		/*  33 = access */
	"old nice",		/*  34 = old nice */
	"old ftime",		/*  35 = old ftime */
	"sync",			/*  36 = sync */
	"kill",			/*  37 = kill */
	"stat",			/*  38 = stat */
	"old setpgrp",		/*  39 = old setpgrp */
	"lstat",		/*  40 = lstat */
	"dup",			/*  41 = dup */
	"pipe",			/*  42 = pipe */
	"old times",		/*  43 = old times */
	"profil",		/*  44 = profil */
	"#45",			/*  45 = nosys */
	"old setgid",		/*  46 = old setgid */
	"getgid",		/*  47 = getgid */
	"old signal",		/*  48 = old sig */
	"#49",			/*  49 = reserved for USG */
	"#50",			/*  50 = reserved for USG */
	"acct",			/*  51 = turn acct off/on */
	"old phys - nosys",	/*  52 = old set phys addr */
	"old lock - nosys",	/*  53 = old lock in core */
	"ioctl",		/*  54 = ioctl */
	"reboot",		/*  55 = reboot */
	"old mpx - nosys",	/*  56 = old mpxchan */
	"symlink",		/*  57 = symlink */
	"readlink",		/*  58 = readlink */
	"execve",		/*  59 = execve */
	"umask",		/*  60 = umask */
	"chroot",		/*  61 = chroot */
	"fstat",		/*  62 = fstat */
	"#63",			/*  63 = used internally */
	"getpagesize",		/*  64 = getpagesize */
	"mremap",		/*  65 = mremap */
	"vfork",		/*  66 = vfork */
	"old vread - read",	/*  67 = old vread */
	"old vwrite - write",	/*  68 = old vwrite */
	"sbrk",			/*  69 = sbrk */
	"sstk",			/*  70 = sstk */
	"mmap",			/*  71 = mmap */
	"old vadvise",		/*  72 = old vadvise */
	"munmap",		/*  73 = munmap */
	"mprotect",		/*  74 = mprotect */
	"madvise",		/*  75 = madvise */
	"vhangup",		/*  76 = vhangup */
	"old vlimit",		/*  77 = old vlimit */
	"mincore",		/*  78 = mincore */
	"getgroups",		/*  79 = getgroups */
	"setgroups",		/*  80 = setgroups */
	"getpgrp",		/*  81 = getpgrp */
	"setpgrp",		/*  82 = setpgrp */
	"setitimer",		/*  83 = setitimer */
	"wait",			/*  84 = wait */
	"swapon",		/*  85 = swapon */
	"getitimer",		/*  86 = getitimer */
	"gethostname",		/*  87 = gethostname */
	"sethostname",		/*  88 = sethostname */
	"getdtablesize",	/*  89 = getdtablesize */
	"dup2",			/*  90 = dup2 */
	"getdopt",		/*  91 = getdopt */
	"fcntl",		/*  92 = fcntl */
	"select",		/*  93 = select */
	"setdopt",		/*  94 = setdopt */
	"fsync",		/*  95 = fsync */
	"setpriority",		/*  96 = setpriority */
	"socket",		/*  97 = socket */
	"connect",		/*  98 = connect */
	"accept",		/*  99 = accept */
	"getpriority",		/* 100 = getpriority */
	"send",			/* 101 = send */
	"recv",			/* 102 = recv */
	"sigreturn",		/* 103 = sigreturn */
	"bind",			/* 104 = bind */
	"setsockopt",		/* 105 = setsockopt */
	"listen",		/* 106 = listen */
	"old vtimes",		/* 107 = old vtimes */
	"sigvec",		/* 108 = sigvec */
	"sigblock",		/* 109 = sigblock */
	"sigsetmask",		/* 110 = sigsetmask */
	"sigpause",		/* 111 = sigpause */
	"sigstack",		/* 112 = sigstack */
	"recvmsg",		/* 113 = recvmsg */
	"sendmsg",		/* 114 = sendmsg */
#ifdef TRACE
	"old vtrace",		/* 115 = old vtrace */
#else
	"#115",			/* 115 = nosys */
#endif
	"gettimeofday",		/* 116 = gettimeofday */
	"getrusage",		/* 117 = getrusage */
	"getsockopt",		/* 118 = getsockopt */
#ifdef vax
	"resuba",		/* 119 = resuba */
#else
	"#119",			/* 119 = nosys */
#endif
	"readv",		/* 120 = readv */
	"writev",		/* 121 = writev */
	"settimeofday",		/* 122 = settimeofday */
	"fchown",		/* 123 = fchown */
	"fchmod",		/* 124 = fchmod */
	"recvfrom",		/* 125 = recvfrom */
	"setreuid",		/* 126 = setreuid */
	"setregid",		/* 127 = setregid */
	"rename",		/* 128 = rename */
	"truncate",		/* 129 = truncate */
	"ftruncate",		/* 130 = ftruncate */
	"flock",		/* 131 = flock */
	"old portal - nosys",	/* 132 = old portal */
	"sendto",		/* 133 = sendto */
	"shutdown",		/* 134 = shutdown */
	"socketpair",		/* 135 = socketpair */
	"mkdir",		/* 136 = mkdir */
	"rmdir",		/* 137 = rmdir */
	"utimes",		/* 138 = utimes */
	"4.2 sigreturn",	/* 139 = old 4.2 sigreturn */
	"adjtime",		/* 140 = adjtime */
	"getpeername",		/* 141 = getpeername */
	"gethostid",		/* 142 = gethostid */
	"sethostid",		/* 143 = sethostid */
	"getrlimit",		/* 144 = getrlimit */
	"setrlimit",		/* 145 = setrlimit */
	"killpg",		/* 146 = killpg */
	"#147",			/* 147 = nosys */
#ifndef VFS
	"setquota",		/* 148 = setquota */
	"quota",		/* 149 = quota */
#else !VFS
	"old setquota",		/* 148 = setquota */
	"old quota",		/* 149 = quota */
#endif !VFS
	"getsockname",		/* 150 = getsockname */
	"exect",		/* 151 = exect (exec with trace) */
#ifdef KCALL
	"kcall",		/* 152 = kcall */
#else
	"#152",			/* 152 = nosys */
#endif
#ifdef	ibm032
	"getfpemulator",		/* 153 = getfpemulator */
#else	ibm032
#ifdef VFS
	"#153",
#else VFS
	0,
#endif VFS
#endif	ibm032
#if	defined(AFS) || defined(VICE)
	"iopen",			/* 154 = iopen */
	"iread",			/* 155 = iread */
	"iwrite",			/* 156 = iwrite */
	"iinc",				/* 157 = iinc */
	"idec",				/* 158 = idec */
#else
	"#154",				/* 154 = nosys */
	"#155",				/* 155 = nosys */
	"#156",				/* 156 = nosys */
	"#157",				/* 157 = nosys */
	"#158",				/* 158 = nosys */
#endif
#if	defined(AFS) || defined(VICE)
	"pioctl",			/* 159 = pioctl */
	"setpag",			/* 160 = setpag */
#else
	"#159",				/* 159 = nosys */
	"#160",				/* 160 = nosys */
#endif
	"vdspin",			/* 161 = vdspin (RVD) */
	"vdspind",			/* 162 = vdspind (RVD) */
	"vdstats",			/* 163 = vdstats (RVD) */	
#if	defined(ibm032) && defined(SYSCALLTRACE)
	"syscalltrace",			/* 164 = syscalltrace */
#else
	"#164",				/* 164 = nosys */
#endif SYSCALLTRACE
#ifdef VICE
	"icreate",			/* 165 = icreate */
#else
	"#165",				/* 165 = nosys */
#endif VICE
	"adjtime",			/* 166 = adjtime */
#ifdef	ibm032
	"getfloatstate",		/* 167 = getfloatstate */
	"setfloatstate",		/* 168 = setfloatstate */
#else	ibm032
#ifdef VFS
	"#167",
	"#168",
#else VFS
	0,
	0,
#endif VFS
#endif	ibm032
#ifdef VFS
#ifdef NFS
	"nfs_svc",		/* 169 = nfs_svc */
#else NFS
	"#169",			/* 169 = nosys */
#endif NFS
	"getdirentries",	/* 170 = getdirentries */
	"statfs",		/* 171 = statfs */
	"fstatfs",		/* 172 = fstatfs */
	"unmount",		/* 173 = unmount */
#ifdef NFS
	"async_daemon",		/* 174 = async_daemon */
	"getfh", 		/* 175 = nfs_getfh */
#else NFS
	"#174",			/* 174 = nosys */
	"#175",			/* 175 = nosys */
#endif NFS
	"getdomainname",	/* 176 = getdomainname */
	"setdomainname",	/* 177 = setdomainname */
#ifdef QUOTA
	"quotactl",		/* 178 = quotactl */
#else QUOTA
	"#178",			/* 178 = nullsys */
#endif QUOTA
#ifdef NFS
	"exportfs",		/* 179 = exportfs */
#else NFS
	"#179",			/* 179 = nosys */
#endif NFS
	"nfsmount",		/* 180 = mount */
#else VFS
	"#169",			/* 169 = nosys */
	"#170",			/* 170 = nosys */
	"#171",			/* 171 = nosys */
	"#172",			/* 172 = nosys */
	"#173",			/* 173 = nosys */
	"#174",			/* 174 = nosys */
	"#175",			/* 175 = nosys */
	"#176",			/* 176 = nosys */
	"#177",			/* 177 = nosys */
	"#178",			/* 178 = nosys */
	"#179",			/* 179 = nosys */
	"#180",			/* 180 = nosys */
#endif VFS
#ifdef AFS
	"afstest",		/* 181 = afstest */
#else AFS
	"#181",			/* 181 = nosys */
#endif AFS
};
