/* $Header:mklock.c 12.0$ */
/* $ACIS:mklock.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/support/lib/RCS/mklock.c,v $ */

#ifndef lint
static char *rcsid = "$Header:mklock.c 12.0$";
#endif

/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* make a zero length file using 4.2 BSD open.  Uses the same code
 * as /etc/vipw to check to make sure the file does not exist:races should
 * not occur.
 * sysopsis:	mkptmp filename
 *  try to create filename.
 * 
 * diagnostics:
 *	exit(0) file was created (and has a length of zero).
 *	exit(1) could not create, file was there.
 *	exit(2) something more serious, e.g. improper program usage or
 *		could not write directory. 
 *		appropriate error diagnostic will be printed on stderr.
 *		on an exit(2).
 */
#include <stdio.h>
#include <sys/file.h>
#include <sys/errno.h>

extern int errno;

main(argc,argv)
int argc;
char *argv[];
{
	int fd;
	char *filename;

	if (argc != 2) {
		fprintf(stderr,"usage:%s filename\n", argv[0]);
		exit(2);
	}
	filename = argv[1];
	fd = open(filename, O_WRONLY|O_CREAT|O_EXCL, 0644);
	if (fd < 0) {
		if (errno == EEXIST)
			exit(1);
		fprintf(stderr, "%s: ",argv[0]); perror(filename);
		exit(2);
	}
	exit(0);
}
