/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:std_emul.c 12.0$ */
/* $ACIS:std_emul.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/std_emul.c,v $ */

#ifndef lint
static char *rcsid = "$Header:std_emul.c 12.0$";
#endif

#include "param.h"
#include "conf.h"

#include "sa.h"

#include "screen_conf.h"
#include "consdefs.h"
#include "std_emul.h"

int nulldev();				/* Returns False (0) */
int nodev();				/* Returns NODEV */

#include "mono.h"
#if NMONO > 0
int lp_put();
#else
#define lp_put	nodev 
#endif NMONO

#include "aed.h"
#if NAED > 0
int aed_screen_init();
int aed_screen_putc();
int aed_put_status();
#else
#define aed_screen_init nodev  
#define aed_screen_putc nodev  
#define aed_put_status	nodev  
#endif NAED

int in_stde = 0;


stdoe_open(dev, tp, si)
dev_t dev;
register struct tty *tp;
register SCREEN_INFO *si;
{
	++in_stde;
	return (0);
}
stdie_open(dev, tp, si)
dev_t dev;
register struct tty *tp;
register SCREEN_INFO *si;
{
	++in_stde;
	return (0);
}

stde_close(tp, si)
register struct tty *tp;
register SCREEN_INFO *si;
{
	register EMUL_INFO *ei = &si->ine;

	if (--in_stde) {
		return (0);
	} 
	ei->flag = 0;
	ei->unit = 0;
	return (0);
}


/*
 * output a character to the RAW screen
 * we look at the characters passing thru to see if 
 * they are something interesting before passing them through
 */
stde_putc(c, si)
register int c;
register SCREEN_INFO *si;
{
	/* Output Emulator Information */
	register EMUL_INFO *ei = &si->oute;
	register int count;
	register int i;
	register int s;
	extern int print_log;

	if (c == 07)
		beep();		/* ring the bell */
	else			/* support non-flashing screen */
		screen_putc (c, NORMAL_VIDEO);
	if (print_log && lp_put(c)) /* log to printer */
		print_log = 0; /* error - stop logging */
}

stde_put_status(si, pos, str)
register SCREEN_INFO *si;
register int pos;
register char *str;
{
/* this is called stde_put_status. The intent is to pass status to whichever
of the "smart" devices is the present screen. Presently, aed is the only one.
All aed emulation is within the microcode. For now, no switch table is used.
Modify by using an emulator switch table. (See the macro definition of 
screen_putc in screen_conf.h) */

aed_put_status(pos,str);
}
