/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pcifprint.c 12.0$ */
/* $ACIS:pcifprint.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/pcifprint.c,v $ */

/*  PS/2 utilities for ATR  */

#ifndef lint
static char *rcsid = "$Header:pcifprint.c 12.0$";
#endif

#include <ctype.h>
#include <assert.h>
#include "init.h"
#include "cmds.h"

#include "sa.h"
#include "../machine/cpu.h"
#include "../caio/hdconfig.h"    /* for diskinfo structure definition */
#include "../ca_atr/pcif.h"		/* need cbcb to get data from keyboard */

extern ushort *pcif_base;

struct pcifinfo {
char	*text;		/* descriptive text */
char	*format;	/* format item */
int	offset;		/* offset into PC/IF */
char	*bformat;	/* %b format item */
} pcif_info[] = {
	{ "window pointer 0", "%x", R_WIND1, 0, },
	{ "window pointer 1", "%x", R_WIND2, 0, },
	{ "window pointer 2", "%x", R_WIND3, 0, },
	{ "window pointer 3", "%x", R_WIND4, 0, },
	{ "128kb window ptr", "%x", P_WIND128, 0, },
	{ "512kb window ptr", "%x", P_WIND512, 0, },
	{ "pcif control",	"%b", P_CTRL, "\20\1BUFF0\2BUFF1\3BUFF2\4BUFF3\5ECC-ENABLE\6DIAG\7WIND0&1\10WIND2&3" },
	{ "pcif status",	"%b", P_STAT, "\20\3MUL-BIT-ERR\5ILL-ADDR-MAP\6ILL-ROMP-ADDR\7ECC-CORRECTED\10IOCC-CHECK" },
	{ "system base addr",	"%x", P_BASE, 0 },
	{ "ecc",	"%x", P_ECCR, 0 },
	{ "pcif config status",	"%b", P_CONF, "\20\6PARITY-ENABLED\7TIMEOUT-COUNT-ENABLED\10AT-MODE" },
	{ "romp diagnostics",	"%b", R_DIAG, "\20\10HOLD-RSC-STATUS" },
	{ "~romp clock",	"%b", R_CLOCK, "\20\1TIT3-DISABLE\2SCAN-GATE\3REG-FILE-READ\4INSTN-STOP-ENABLE\5ROMPC-STEP\6DEBUG-STOP\7ROMPC-RESET\10POR" },
	{ "romp control",	"%b", R_CTRL, "\20\1INT-ENABLE\2INT-REQUEST\4INTERLEAVED\6MASTER-MODE\7IPL\10HOLD-RSC" },
	{ "romp interrrupt",	"%b", R_INTR, "\20\1INT7\2INT6\3INT5\4INT4\5INT3\6INT2\7INT1\10INT0" },
	{ "~romp status",	"%b", R_STAT, "\20\1STOP\2DGO\3INSTN-COMPLETE\4SYNC\5FAIL\6WAIT\7CLOCK-STOPPED\10IPL-READY" },
	{ 0, 0, 0, 0 }
};

/*
 * code to display current PC/IF status
 */
pcif_print()
{
	unsigned char info;
	struct pcifinfo *p;
	for (p=pcif_info; p->format; ++p) {
		printf("pcif register %2d @ inb %03x",
			p->offset, p->offset + *pcif_base);
		printf(" (%-18s) = ", p->text);
		info = IOIN(*pcif_base + p->offset + pcif_io_b);
		if (p->text[0] == '~')
			info = ~info;	/* complement the bits */
		printf(p->format, info, p->bformat);
		printf("\n");
	}
}
