/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:vdreg.h 12.0$ */
/* $ACIS:vdreg.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/caio/RCS/vdreg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidvdreg = "$Header:vdreg.h 12.0$";
#endif


/* Include file for virtual disk driver */
/* Written by Michael Greenwald, April 1982 */
/* Modified by Jis 12/5/85 to add "mode" to vd_device. */

#include "../netinet/rvd.h"
#include "../machineio/vdconst.h"
#include "../netinet/in.h"

#define u_long	unsigned long
#define u_short	unsigned short

#define	VD_VERSION	2	/* structure version */

/* Drive descriptor for virtual disk */

struct vd_device {
	long	drive;		/* Drive number */
	u_char	status;		/* status of drive */
	u_char	bfactor;	/* Blocking factor for writes */
	u_short	state;
	u_long	nblocks;	/* Size of disk in blocks */
	u_long	index;		/* Server specified index */
	u_long	nonce;		/* Current UID for packets from this drive */
	struct	in_addr server;	/* Address of server where this disk actually resides */
	u_short mode;		/* Mode spunup in */
	u_short	q_len;		/* Current length of queued requests */
	u_short burst;		/* Maximum burst size to server */
	u_short maxqlen;	/* Maximum number of outstanding request on this drive */
	u_short	reqs_out;	/* Current number of outstanding requests */
	char	capability[VD_CAPAB_LEN];	/* Capability for spindown */
	};

struct spinargs {
	char	name[VD_NAME_LEN];	/* Pack Name */
	char	capab[VD_CAPAB_LEN];	/* Capability for pack in specified mode */
	};

struct vd_long_dev {
	struct	vd_device	vd_device;
	struct	spinargs	args;
	u_long	vd_uid;		/* Virtual Disk Unique ID: gotten from server */
};


/* Accumulate statistics for Virtual disk in this structure */

struct vd_stat {
	u_long	bad_blk;	/* Number of bad block numbers received -
				   i.e. responses from server that had no
				   waiting block or drive on our side */
	u_long	bad_cksum;	/* Number of packets with bad checksum */
	u_long	bad_type;	/* not a packet type that we deal with */
	u_long	timeout;	/* Number of requests that timed out */
	u_long	bad_nonce;	/* Nonce did not agree */
	u_long	bad_state;	/* Packet arrived but state was inaproopriate */
	u_long	bad_data;	/* Data was invalid */
	u_long	pkts_sent;	/* Number of packets sent */
	u_long	blk_rqs;	/* Number of blocks requested */
	u_long	rxmts;		/* Number of retransmits */
	u_long	pkts_rcvd;	/* Number of RVD packets received */
	u_long	blk_wrt;	/* Number of blocks written */
	u_long	q_size[STQLEN];
	u_long	err_rcv;	/* # error pkts rcvd from server */
	u_long	bad_vers;	/* # pkts with bad version */
	u_long	bad_frmt;	/* # pkts that were badly formed */
	u_long	pkt_rej;	/* # pkts that local host wouldn't send */
	u_long	pushes;		/* Number of requests (bufs) delayed because of flow control */
	};

struct vd_longstat {
	short	struct_vers;	/* struct version number */
	short	num_drives;	/* number of drives configured */
	u_long	long_rxmts;	/* number of long timeout retransmits */
	struct	vd_stat vdstat;
	short	blk_major;	/* Major number of VD block device */
	short	char_major;	/* Major number of VD character device */
};

#define vdnblks(bytes)	(((bytes) + VDBSIZE - 1) >> VDBSHIFT)
#define	vdkblock(bp)	((bp)->b_blkno)


#if defined(KERNEL) || defined(STANDALONE) || defined(STANDUTIL)
#include "ioctl.h"
#else
#include <sys/ioctl.h>
#endif

/* Structures and definitions for vd io control commands */

struct vd_spinup {
	u_long	drive;
	struct	spinargs *uspin;
	u_long	mode;
	struct	sockaddr_in *server;
	u_long	*errp;
};

#ifdef KERBEROS
#include <krb.h>
#endif KERBEROS

struct vd_auth_spinup {
	u_long	drive;
	struct	spinargs *uspin;
	u_long	mode;
	struct	sockaddr_in *server;
	u_long	*errp;
#ifdef KERBEROS
	KTEXT	authent;
#endif KERBEROS
};

/* vd io control commands */

#define	VDIOCSPINUP	_IOW(v, 1, struct vd_spinup)	/* do a spinup */
#define	VDIOCSPINDOWN	_IOW(v, 2, u_long)		/* do a spindown */
#define	VDIOCGETSTAT	_IOW(v, 3, struct vd_longstat *)	/* get stats */
#define	VDIOCGETDRIVE	_IOW(v, 4, struct vd_long_dev *)	/* get drives */
#define	VDIOCSPINDFORCE	_IOW(v, 5, u_long)	/* do a forced spindown */
#define	VDIOCABORT	_IOW(v, 6, u_long)	/* abort and spindown a drive */
						/* do an authenticated spinup */
#define	VDIOCAUTHSPINUP	_IOW(v, 7, struct vd_auth_spinup)
